/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.business.impl.service.identifiable.entity.parts;

import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.NodeRepository;
import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.parts.ContentNodeRepository;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.entity.parts.ContentNodeService;
import de.digitalcollections.cudami.admin.business.impl.service.identifiable.IdentifiableServiceImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.IdentifiablesContainer;
import de.digitalcollections.model.api.identifiable.Node;
import de.digitalcollections.model.api.identifiable.entity.parts.ContentNode;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.validation.Errors;

@Service
public class ContentNodeServiceImpl<I extends Identifiable>
extends IdentifiableServiceImpl<ContentNode>
implements ContentNodeService<ContentNode, I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentNodeServiceImpl.class);

    @Autowired
    public ContentNodeServiceImpl(ContentNodeRepository<ContentNode, I> repository) {
        super(repository);
    }

    @Override
    public void addIdentifiable(UUID contentNodeUuid, UUID identifiableUuid) {
        ((ContentNodeRepository)this.repository).addIdentifiable(contentNodeUuid, identifiableUuid);
    }

    @Override
    public ContentNode saveWithParentContentTree(ContentNode contentNode, UUID parentContentTreeUUID, Errors results) throws IdentifiableServiceException {
        if (!results.hasErrors()) {
            try {
                contentNode = ((ContentNodeRepository)this.repository).saveWithParentContentTree(contentNode, parentContentTreeUUID);
            }
            catch (Exception e) {
                LOGGER.error("Cannot save top-level content node " + contentNode + ": ", (Throwable)e);
                throw new IdentifiableServiceException(e.getMessage());
            }
        }
        return contentNode;
    }

    @Override
    public ContentNode saveWithParentContentNode(ContentNode contentNode, UUID parentContentNodeUUID, Errors results) throws IdentifiableServiceException {
        if (!results.hasErrors()) {
            try {
                contentNode = ((ContentNodeRepository)this.repository).saveWithParentContentNode(contentNode, parentContentNodeUUID);
            }
            catch (Exception e) {
                LOGGER.error("Cannot save content node " + contentNode + ": ", (Throwable)e);
                throw new IdentifiableServiceException(e.getMessage());
            }
        }
        return contentNode;
    }

    @Override
    public List<ContentNode> getChildren(ContentNode node) {
        return ((NodeRepository)this.repository).getChildren((Node)node);
    }

    @Override
    public List<ContentNode> getChildren(UUID uuid) {
        return ((NodeRepository)this.repository).getChildren(uuid);
    }

    @Override
    public List<Identifiable> getIdentifiables(ContentNode contentNode) {
        return ((ContentNodeRepository)this.repository).getIdentifiables((IdentifiablesContainer)contentNode);
    }

    @Override
    public List<Identifiable> saveIdentifiables(ContentNode contentNode, List<Identifiable> identifiables) {
        return ((ContentNodeRepository)this.repository).saveIdentifiables((IdentifiablesContainer)contentNode, identifiables);
    }
}

