/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.business.impl.service.identifiable.entity.parts;

import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.NodeRepository;
import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.parts.WebpageRepository;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.entity.parts.WebpageService;
import de.digitalcollections.cudami.admin.business.impl.service.identifiable.IdentifiableServiceImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.IdentifiablesContainer;
import de.digitalcollections.model.api.identifiable.Node;
import de.digitalcollections.model.api.identifiable.entity.parts.Webpage;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.validation.Errors;

@Service
public class WebpageServiceImpl<I extends Identifiable>
extends IdentifiableServiceImpl<Webpage>
implements WebpageService<Webpage, I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebpageServiceImpl.class);

    @Autowired
    public WebpageServiceImpl(WebpageRepository<Webpage, I> repository) {
        super(repository);
    }

    @Override
    public void addIdentifiable(UUID webpageUuid, UUID identifiableUuid) {
        ((WebpageRepository)this.repository).addIdentifiable(webpageUuid, identifiableUuid);
    }

    @Override
    public Webpage saveWithParentWebsite(Webpage webpage, UUID parentWebsiteUUID, Errors results) throws IdentifiableServiceException {
        if (!results.hasErrors()) {
            try {
                webpage = ((WebpageRepository)this.repository).saveWithParentWebsite(webpage, parentWebsiteUUID);
            }
            catch (Exception e) {
                LOGGER.error("Cannot save top-level webpage " + webpage + ": ", (Throwable)e);
                throw new IdentifiableServiceException(e.getMessage());
            }
        }
        return webpage;
    }

    @Override
    public Webpage saveWithParentWebpage(Webpage webpage, UUID parentWebpageUUID, Errors results) throws IdentifiableServiceException {
        if (!results.hasErrors()) {
            try {
                webpage = ((WebpageRepository)this.repository).saveWithParentWebpage(webpage, parentWebpageUUID);
            }
            catch (Exception e) {
                LOGGER.error("Cannot save webpage " + webpage + ": ", (Throwable)e);
                throw new IdentifiableServiceException(e.getMessage());
            }
        }
        return webpage;
    }

    @Override
    public List<Webpage> getChildren(Webpage webpage) {
        return ((NodeRepository)this.repository).getChildren((Node)webpage);
    }

    @Override
    public List<Webpage> getChildren(UUID uuid) {
        return ((NodeRepository)this.repository).getChildren(uuid);
    }

    @Override
    public List<Identifiable> getIdentifiables(Webpage webpage) {
        return ((WebpageRepository)this.repository).getIdentifiables((IdentifiablesContainer)webpage);
    }

    @Override
    public List<Identifiable> saveIdentifiables(Webpage webpage, List<Identifiable> identifiables) {
        return ((WebpageRepository)this.repository).saveIdentifiables((IdentifiablesContainer)webpage, identifiables);
    }
}

