/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.business.impl.service.identifiable.resource;

import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.resource.CudamiFileResourceRepository;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.resource.CudamiFileResourceService;
import de.digitalcollections.cudami.admin.business.impl.service.identifiable.IdentifiableServiceImpl;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.validation.Errors;

@Service
public class CudamiFileResourceServiceImpl<F extends FileResource>
extends IdentifiableServiceImpl<F>
implements CudamiFileResourceService<F> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CudamiFileResourceServiceImpl.class);

    @Autowired
    public CudamiFileResourceServiceImpl(CudamiFileResourceRepository<F> repository) {
        super(repository);
    }

    @Override
    public F save(FileResource fileResource, byte[] bytes, Errors results) throws IdentifiableServiceException {
        if (!results.hasErrors()) {
            try {
                fileResource = ((CudamiFileResourceRepository)this.repository).save(fileResource, bytes);
            }
            catch (Exception e) {
                LOGGER.error("Cannot save fileResource " + fileResource + ": ", (Throwable)e);
                throw new IdentifiableServiceException(e.getMessage());
            }
        }
        return (F)fileResource;
    }
}

