/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.business.impl.service.security;

import de.digitalcollections.cudami.admin.backend.api.repository.security.UserRepository;
import de.digitalcollections.cudami.admin.business.api.service.security.UserService;
import de.digitalcollections.cudami.admin.business.impl.validator.PasswordsValidatorParams;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.security.enums.Role;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Service
@Transactional(readOnly=true)
public class UserServiceImpl
implements UserService<de.digitalcollections.model.api.security.User> {
    @Autowired
    @Qualifier(value="passwordsValidator")
    private Validator passwordsValidator;
    @Autowired
    @Qualifier(value="uniqueUsernameValidator")
    private Validator uniqueUsernameValidator;
    @Autowired
    private UserRepository userRepository;

    @Override
    @Transactional(readOnly=false)
    public de.digitalcollections.model.api.security.User activate(UUID uuid) {
        de.digitalcollections.model.api.security.User user = this.userRepository.findOne(uuid);
        user.setEnabled(true);
        user = this.userRepository.update(user);
        return user;
    }

    @Override
    public long count() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public de.digitalcollections.model.api.security.User create() {
        return this.userRepository.create();
    }

    @Override
    @Transactional(readOnly=false)
    public de.digitalcollections.model.api.security.User create(de.digitalcollections.model.api.security.User user, String password1, String password2, Errors results) {
        this.uniqueUsernameValidator.validate((Object)user, results);
        if (!results.hasErrors()) {
            return this.save(password1, password2, user, results, false);
        }
        return null;
    }

    @Override
    public de.digitalcollections.model.api.security.User createAdminUser() {
        de.digitalcollections.model.api.security.User user = this.create();
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.add(Role.ADMIN);
        user.setRoles(roles);
        return user;
    }

    @Override
    @Transactional(readOnly=false)
    public de.digitalcollections.model.api.security.User deactivate(UUID uuid) {
        de.digitalcollections.model.api.security.User user = this.userRepository.findOne(uuid);
        user.setEnabled(false);
        user = this.userRepository.update(user);
        return user;
    }

    @Override
    public boolean doesActiveAdminUserExist() {
        List findActiveAdminUsers = this.userRepository.findActiveAdminUsers();
        return findActiveAdminUsers != null && !findActiveAdminUsers.isEmpty();
    }

    @Override
    public PageResponse<de.digitalcollections.model.api.security.User> find(PageRequest pageRequest) {
        return this.userRepository.find(pageRequest);
    }

    @Override
    public de.digitalcollections.model.api.security.User findOne(UUID uuid) {
        return this.userRepository.findOne(uuid);
    }

    @Override
    public List<de.digitalcollections.model.api.security.User> findAll() {
        return this.userRepository.findAll();
    }

    @Transactional(readOnly=true, noRollbackFor={UsernameNotFoundException.class})
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        de.digitalcollections.model.api.security.User user = this.userRepository.findByEmail(username);
        if (user == null || !user.isEnabled()) {
            throw new UsernameNotFoundException(String.format("User \"%s\" was not found.", username));
        }
        List authorities = user.getRoles();
        return this.buildUserForAuthentication(user, authorities);
    }

    private User buildUserForAuthentication(de.digitalcollections.model.api.security.User user, List<? extends GrantedAuthority> authorities) {
        return new User(user.getEmail(), user.getPasswordHash(), user.isEnabled(), true, true, true, authorities);
    }

    @Override
    @Transactional(readOnly=false)
    public de.digitalcollections.model.api.security.User update(de.digitalcollections.model.api.security.User user, String password1, String password2, Errors results) {
        return this.save(password1, password2, user, results, true);
    }

    private de.digitalcollections.model.api.security.User save(String password1, String password2, de.digitalcollections.model.api.security.User user, Errors results, boolean isUpdate) {
        PasswordsValidatorParams passwordsValidatorParams = new PasswordsValidatorParams(password1, password2, user.getPasswordHash());
        String password = passwordsValidatorParams.getPassword1();
        if (!StringUtils.isEmpty((Object)password)) {
            this.passwordsValidator.validate((Object)passwordsValidatorParams, results);
        }
        if (!results.hasErrors()) {
            if (!StringUtils.isEmpty((Object)password)) {
                BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
                String passwordHash = passwordEncoder.encode((CharSequence)password);
                user.setPasswordHash(passwordHash);
            }
            user = isUpdate ? this.userRepository.update(user) : this.userRepository.save(user);
        }
        return user;
    }
}

