/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.business.impl.service.identifiable.entity;

import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.DigitalObjectRepository;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.entity.DigitalObjectService;
import de.digitalcollections.cudami.admin.business.impl.service.identifiable.entity.EntityServiceImpl;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import java.util.LinkedHashSet;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DigitalObjectServiceImpl
extends EntityServiceImpl<DigitalObject>
implements DigitalObjectService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigitalObjectServiceImpl.class);

    @Autowired
    public DigitalObjectServiceImpl(DigitalObjectRepository repository) {
        super(repository);
    }

    @Override
    public LinkedHashSet<FileResource> getFileResources(DigitalObject digitalObject) {
        return this.getFileResources(digitalObject.getUuid());
    }

    @Override
    public LinkedHashSet<FileResource> getFileResources(UUID digitalObjectUuid) {
        return ((DigitalObjectRepository)this.repository).getFileResources(digitalObjectUuid);
    }

    @Override
    public LinkedHashSet<ImageFileResource> getImageFileResources(DigitalObject digitalObject) {
        return this.getImageFileResources(digitalObject.getUuid());
    }

    @Override
    public LinkedHashSet<ImageFileResource> getImageFileResources(UUID digitalObjectUuid) {
        return ((DigitalObjectRepository)this.repository).getImageFileResources(digitalObjectUuid);
    }

    @Override
    public LinkedHashSet<FileResource> saveFileResources(DigitalObject digitalObject, LinkedHashSet<FileResource> fileResources) {
        return this.saveFileResources(digitalObject.getUuid(), fileResources);
    }

    @Override
    public LinkedHashSet<FileResource> saveFileResources(UUID digitalObjectUuid, LinkedHashSet<FileResource> fileResources) {
        return ((DigitalObjectRepository)this.repository).saveFileResources(digitalObjectUuid, fileResources);
    }
}

