/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.business.impl.service.identifiable.entity.parts;

import de.digitalcollections.cudami.admin.backend.api.repository.identifiable.entity.parts.ContentNodeRepository;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.entity.parts.ContentNodeService;
import de.digitalcollections.cudami.admin.business.impl.service.identifiable.entity.parts.EntityPartServiceImpl;
import de.digitalcollections.model.api.identifiable.Node;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.parts.ContentNode;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContentNodeServiceImpl<E extends Entity>
extends EntityPartServiceImpl<ContentNode, E>
implements ContentNodeService<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentNodeServiceImpl.class);

    @Autowired
    public ContentNodeServiceImpl(ContentNodeRepository<E> repository) {
        super(repository);
    }

    @Override
    public List<ContentNode> getChildren(ContentNode contentNode) {
        return ((ContentNodeRepository)this.repository).getChildren((Node)contentNode);
    }

    @Override
    public List<ContentNode> getChildren(UUID uuid) {
        return ((ContentNodeRepository)this.repository).getChildren(uuid);
    }

    @Override
    public LinkedHashSet<E> getEntities(ContentNode contentNode) {
        return this.getEntities(contentNode.getUuid());
    }

    @Override
    public LinkedHashSet<E> getEntities(UUID contentNodeUuid) {
        return ((ContentNodeRepository)this.repository).getEntities(contentNodeUuid);
    }

    @Override
    public ContentNode getParent(ContentNode node) {
        return this.getParent(node.getUuid());
    }

    @Override
    public ContentNode getParent(UUID nodeUuid) {
        return (ContentNode)((ContentNodeRepository)this.repository).getParent(nodeUuid);
    }

    @Override
    public LinkedHashSet<E> saveEntities(ContentNode contentNode, LinkedHashSet<E> entities) {
        return this.saveEntities(contentNode.getUuid(), entities);
    }

    @Override
    public LinkedHashSet<E> saveEntities(UUID contentNodeUuid, LinkedHashSet<E> entities) {
        return ((ContentNodeRepository)this.repository).saveEntities(contentNodeUuid, entities);
    }

    @Override
    public ContentNode saveWithParentContentTree(ContentNode contentNode, UUID parentContentTreeUuid) throws IdentifiableServiceException {
        try {
            return ((ContentNodeRepository)this.repository).saveWithParentContentTree(contentNode, parentContentTreeUuid);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save top-level content node " + contentNode + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    @Override
    public ContentNode saveWithParentContentNode(ContentNode contentNode, UUID parentContentNodeUuid) throws IdentifiableServiceException {
        try {
            return ((ContentNodeRepository)this.repository).saveWithParentContentNode(contentNode, parentContentNodeUuid);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save content node " + contentNode + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    @Override
    public LinkedHashSet<FileResource> getFileResources(ContentNode contentNode) {
        return this.getFileResources(contentNode.getUuid());
    }

    @Override
    public LinkedHashSet<FileResource> getFileResources(UUID contentNodeUuid) {
        return ((ContentNodeRepository)this.repository).getFileResources(contentNodeUuid);
    }

    @Override
    public LinkedHashSet<FileResource> saveFileResources(ContentNode contentNode, LinkedHashSet<FileResource> fileResources) {
        return this.saveFileResources(contentNode.getUuid(), fileResources);
    }

    @Override
    public LinkedHashSet<FileResource> saveFileResources(UUID contentNodeUuid, LinkedHashSet<FileResource> fileResources) {
        return ((ContentNodeRepository)this.repository).saveFileResources(contentNodeUuid, fileResources);
    }
}

