/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.config;

import de.digitalcollections.cudami.model.api.security.enums.Role;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.boot.autoconfigure.security.servlet.PathRequest;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.authentication.rememberme.InMemoryTokenRepositoryImpl;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
public class SpringConfigSecurity
extends WebSecurityConfigurerAdapter {
    @Value(value="${spring.security.user.name}")
    private String actuatorUsername;
    @Value(value="${spring.security.user.password}")
    private String actuatorPassword;
    @Autowired(required=true)
    PersistentTokenRepository persistentTokenRepository;
    @Autowired(required=true)
    private UserDetailsService userDetailsService;

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        ((AuthenticationManagerBuilder)((InMemoryUserDetailsManagerConfigurer)((InMemoryUserDetailsManagerConfigurer)auth.inMemoryAuthentication().passwordEncoder(this.passwordEncoderDummy())).withUser(User.withUsername((String)this.actuatorUsername).password(this.actuatorPassword).roles(new String[]{"ACTUATOR"}))).and()).authenticationProvider(this.authProvider());
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().requestMatchers(new RequestMatcher[]{EndpointRequest.to((String[])new String[]{"info", "health"})})).permitAll().requestMatchers(new RequestMatcher[]{EndpointRequest.toAnyEndpoint()})).hasRole("ACTUATOR").and()).httpBasic();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().requestMatchers(new RequestMatcher[]{PathRequest.toStaticResources().atCommonLocations()})).permitAll().antMatchers(new String[]{"/api/**", "/setup/**"})).permitAll();
        ((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/users/**"})).hasAnyAuthority(new String[]{Role.ADMIN.getAuthority()}).anyRequest()).authenticated().and()).formLogin().loginPage("/login").permitAll()).and()).logout().logoutUrl("/logout").permitAll().and()).rememberMe().tokenRepository(this.persistentTokenRepository).tokenValiditySeconds(1209600);
    }

    @Bean
    public AuthenticationProvider authProvider() {
        DaoAuthenticationProvider authProvider = new DaoAuthenticationProvider();
        authProvider.setPasswordEncoder((PasswordEncoder)new BCryptPasswordEncoder());
        authProvider.setUserDetailsService(this.userDetailsService);
        return authProvider;
    }

    private PasswordEncoder passwordEncoderDummy() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public PersistentTokenRepository persistentTokenRepository() {
        return new InMemoryTokenRepositoryImpl();
    }
}

