/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.mxab.thymeleaf.extras.dataattribute.dialect.DataAttributeDialect;
import de.digitalcollections.commons.servlet.filter.LogSessionIdFilter;
import de.digitalcollections.commons.springmvc.config.SpringConfigCommonsMvc;
import de.digitalcollections.commons.springmvc.controller.ErrorController;
import de.digitalcollections.cudami.admin.converter.GrantedAuthorityJsonFilter;
import de.digitalcollections.cudami.admin.converter.UserJsonFilter;
import de.digitalcollections.cudami.admin.interceptors.CreateAdminUserInterceptor;
import de.digitalcollections.cudami.model.api.security.User;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.Filter;
import nz.net.ultraq.thymeleaf.LayoutDialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;
import org.springframework.data.web.config.EnableSpringDataWebSupport;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.thymeleaf.dialect.springdata.SpringDataDialect;
import org.thymeleaf.extras.springsecurity4.dialect.SpringSecurityDialect;

@Configuration
@ComponentScan(basePackages={"de.digitalcollections.commons.springmvc.controller"}, excludeFilters={@ComponentScan.Filter(value={ErrorController.class}, type=FilterType.ASSIGNABLE_TYPE)})
@EnableAspectJAutoProxy
@EnableSpringDataWebSupport
@Import(value={SpringConfigCommonsMvc.class})
public class SpringConfigWeb
implements WebMvcConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringConfigWeb.class);
    @Value(value="${cudami.defaultLocale-gui}")
    private String defaultLocaleTag;
    static final String ENCODING = "UTF-8";

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/favicon.ico"}).addResourceLocations(new String[]{"classpath:/static/images/favicon.png"});
    }

    @Bean
    public DataAttributeDialect dataAttributeDialect() {
        return new DataAttributeDialect();
    }

    @Bean
    public LayoutDialect layoutDialect() {
        return new LayoutDialect();
    }

    @Bean
    public SpringDataDialect springDataDialect() {
        return new SpringDataDialect();
    }

    @Bean
    public SpringSecurityDialect springSecurityDialect() {
        return new SpringSecurityDialect();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        LocaleChangeInterceptor localeChangeInterceptor = new LocaleChangeInterceptor();
        localeChangeInterceptor.setParamName("language");
        registry.addInterceptor((HandlerInterceptor)localeChangeInterceptor);
        InterceptorRegistration createAdminUserInterceptorRegistration = registry.addInterceptor((HandlerInterceptor)this.createAdminUserInterceptor());
        createAdminUserInterceptorRegistration.addPathPatterns(new String[]{"/login"});
    }

    @Bean(name={"localeResolver"})
    public CookieLocaleResolver localeResolver() {
        CookieLocaleResolver localeResolver = new CookieLocaleResolver();
        Locale defaultLocale = Locale.forLanguageTag(this.defaultLocaleTag);
        LOGGER.info("##### Setting users' default locale for GUI to '{}' (persisted in cookie)", (Object)defaultLocale);
        localeResolver.setDefaultLocale(defaultLocale);
        localeResolver.setCookieMaxAge(Integer.valueOf(1209600));
        return localeResolver;
    }

    @Bean
    public CreateAdminUserInterceptor createAdminUserInterceptor() {
        return new CreateAdminUserInterceptor();
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        StringHttpMessageConverter stringHMC = new StringHttpMessageConverter(Charset.forName(ENCODING));
        converters.add((HttpMessageConverter<?>)stringHMC);
        converters.add(this.mappingJackson2HttpMessageConverter());
        ByteArrayHttpMessageConverter bc = new ByteArrayHttpMessageConverter();
        ArrayList<MediaType> supported = new ArrayList<MediaType>();
        supported.add(MediaType.IMAGE_JPEG);
        supported.add(MediaType.IMAGE_GIF);
        supported.add(MediaType.IMAGE_PNG);
        bc.setSupportedMediaTypes(supported);
        converters.add((HttpMessageConverter<?>)bc);
    }

    @Bean
    public HttpMessageConverter<?> mappingJackson2HttpMessageConverter() {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
        supportedMediaTypes.add(MediaType.APPLICATION_JSON);
        converter.setSupportedMediaTypes(supportedMediaTypes);
        converter.setObjectMapper(this.objectMapper());
        return converter;
    }

    @Bean
    public ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.addMixIn(User.class, UserJsonFilter.class);
        objectMapper.addMixIn(GrantedAuthority.class, GrantedAuthorityJsonFilter.class);
        return objectMapper;
    }

    public void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
        configurer.enable();
    }

    @Bean
    public FilterRegistrationBean logSessionIdFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new LogSessionIdFilter());
        return registration;
    }
}

