/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.security;

import de.digitalcollections.commons.springdata.domain.PageConverter;
import de.digitalcollections.commons.springdata.domain.PageWrapper;
import de.digitalcollections.commons.springdata.domain.PageableConverter;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.core.model.api.paging.PageRequest;
import de.digitalcollections.core.model.api.paging.PageResponse;
import de.digitalcollections.cudami.admin.business.api.service.security.UserService;
import de.digitalcollections.cudami.model.api.security.User;
import de.digitalcollections.cudami.model.api.security.enums.Role;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@SessionAttributes(value={"user"})
public class UserController
extends AbstractController
implements MessageSourceAware {
    private MessageSource messageSource;
    @Autowired
    UserService userService;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "users";
    }

    @ModelAttribute(value="allRoles")
    protected List<Role> populateAllRoles() {
        return Arrays.asList(Role.values());
    }

    @InitBinder(value={"user"})
    protected void initBinder(WebDataBinder binder) {
    }

    @RequestMapping(value={"/users/{uuid}/activate"}, method={RequestMethod.GET})
    public String activate(@PathVariable UUID uuid, Model model, RedirectAttributes redirectAttributes) {
        User user = this.userService.activate(uuid);
        String message = this.messageSource.getMessage("msg.user_activated", new Object[]{user.getEmail()}, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/users";
    }

    @RequestMapping(value={"/users/{uuid}/deactivate"}, method={RequestMethod.GET})
    public String deactivate(@PathVariable UUID uuid, Model model, RedirectAttributes redirectAttributes) {
        User user = this.userService.deactivate(uuid);
        String message = this.messageSource.getMessage("msg.user_deactivated", new Object[]{user.getEmail()}, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("warning_message", (Object)message);
        return "redirect:/users";
    }

    @RequestMapping(value={"/users/new"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("user", (Object)this.userService.create());
        model.addAttribute("isNew", (Object)true);
        return "users/edit";
    }

    @RequestMapping(value={"/users/new"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="pwd1") String password1, @RequestParam(value="pwd2") String password2, @ModelAttribute @Valid User user, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        this.verifyBinding(results);
        if (results.hasErrors()) {
            model.addAttribute("isNew", (Object)true);
            return "users/edit";
        }
        user = this.userService.create(user, password1, password2, (Errors)results);
        if (results.hasErrors()) {
            model.addAttribute("isNew", (Object)true);
            return "users/edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.created_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/users/" + user.getUuid();
    }

    @RequestMapping(value={"/users/{uuid}/edit"}, method={RequestMethod.GET})
    public String edit(@PathVariable UUID uuid, Model model) {
        model.addAttribute("user", (Object)this.userService.findOne(uuid));
        model.addAttribute("isNew", (Object)false);
        return "users/edit";
    }

    @RequestMapping(value={"/users/{uuid}/edit"}, method={RequestMethod.POST})
    public String edit(@PathVariable UUID uuid, @RequestParam(value="pwd1") String password1, @RequestParam(value="pwd2") String password2, @ModelAttribute @Valid User user, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        this.verifyBinding(results);
        if (results.hasErrors()) {
            model.addAttribute("isNew", (Object)false);
            return "users/edit";
        }
        this.userService.update(user, password1, password2, (Errors)results);
        if (results.hasErrors()) {
            model.addAttribute("isNew", (Object)false);
            return "users/edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changes_saved_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/users/" + uuid;
    }

    @RequestMapping(value={"/users"}, method={RequestMethod.GET})
    public String list(Model model, @PageableDefault(sort={"email"}, size=25) Pageable pageable) {
        PageRequest pageRequest = PageableConverter.convert((Pageable)pageable);
        PageResponse pageResponse = this.userService.find(pageRequest);
        Page page = PageConverter.convert((PageResponse)pageResponse, (PageRequest)pageRequest);
        model.addAttribute("page", (Object)new PageWrapper(page, "/users"));
        return "users/list";
    }

    @RequestMapping(value={"/users/{uuid}"}, method={RequestMethod.GET})
    public String view(@PathVariable UUID uuid, Model model) {
        model.addAttribute("user", (Object)this.userService.findOne(uuid));
        return "users/view";
    }
}

