/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springdata.domain.PageConverter;
import de.digitalcollections.commons.springdata.domain.PageWrapper;
import de.digitalcollections.commons.springdata.domain.PageableConverter;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.business.api.service.LocaleService;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.entity.ContentTreeService;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.ContentTree;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.ContentTreeImpl;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@SessionAttributes(value={"contentTree"})
public class ContentTreesController
extends AbstractController
implements MessageSourceAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentTreesController.class);
    private MessageSource messageSource;
    @Autowired
    LocaleService localeService;
    @Autowired
    ContentTreeService contentTreeService;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "contenttrees";
    }

    @RequestMapping(value={"/contenttrees/new"}, method={RequestMethod.GET})
    public String create(Model model) {
        Locale defaultLocale = this.localeService.getDefault();
        List locales = this.localeService.findAll().stream().filter(locale -> !defaultLocale.equals(locale) && !locale.getDisplayName().isEmpty()).sorted(Comparator.comparing(locale -> locale.getDisplayName(LocaleContextHolder.getLocale()))).collect(Collectors.toList());
        model.addAttribute("contentTree", (Object)this.contentTreeService.create());
        model.addAttribute("defaultLocale", (Object)defaultLocale);
        model.addAttribute("locales", locales);
        return "contenttrees/create";
    }

    @RequestMapping(value={"/contenttrees/new"}, method={RequestMethod.POST})
    public String create(@ModelAttribute @Valid ContentTreeImpl contentTree, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "contenttrees/create";
        }
        ContentTree contentTreeDb = null;
        try {
            contentTreeDb = (ContentTree)this.contentTreeService.save((Identifiable)contentTree, (Errors)results);
            LOGGER.info("Successfully saved content tree");
        }
        catch (Exception e) {
            LOGGER.error("Cannot save content tree: ", (Throwable)e);
            String message = this.messageSource.getMessage("msg.error", null, LocaleContextHolder.getLocale());
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/contenttrees";
        }
        if (results.hasErrors()) {
            return "contenttrees/create";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.created_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/contenttrees/" + contentTreeDb.getUuid().toString();
    }

    @RequestMapping(value={"/contenttrees/{uuid}/edit"}, method={RequestMethod.GET})
    public String edit(@PathVariable UUID uuid, Model model, RedirectAttributes redirectAttributes) {
        ContentTree contentTree = (ContentTree)this.contentTreeService.get(uuid);
        model.addAttribute("contentTree", (Object)contentTree);
        HashSet availableLocales = (HashSet)contentTree.getLabel().getLocales();
        Set availableLocaleTags = availableLocales.stream().map(Locale::toLanguageTag).collect(Collectors.toSet());
        List locales = this.localeService.findAll().stream().filter(locale -> !availableLocaleTags.contains(locale.toLanguageTag()) && !locale.getDisplayName().isEmpty()).sorted(Comparator.comparing(locale -> locale.getDisplayName(LocaleContextHolder.getLocale()))).collect(Collectors.toList());
        model.addAttribute("availableLocales", (Object)availableLocales);
        model.addAttribute("locales", locales);
        return "contenttrees/edit";
    }

    @RequestMapping(value={"/contenttrees/{pathUuid}/edit"}, method={RequestMethod.POST})
    public String edit(@PathVariable UUID pathUuid, @ModelAttribute @Valid ContentTreeImpl contentTree, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "contenttrees/edit";
        }
        try {
            ContentTree contentTreeDb = (ContentTree)this.contentTreeService.get(pathUuid);
            contentTreeDb.setLabel(contentTree.getLabel());
            contentTreeDb.setDescription(contentTree.getDescription());
            this.contentTreeService.update((Identifiable)contentTreeDb, (Errors)results);
        }
        catch (IdentifiableServiceException e) {
            String message = "Cannot save content tree with uuid=" + pathUuid + ": " + (Object)((Object)e);
            LOGGER.error(message, (Throwable)e);
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/contenttrees/" + pathUuid + "/edit";
        }
        if (results.hasErrors()) {
            return "contenttrees/edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changes_saved_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/contenttrees/" + pathUuid;
    }

    @RequestMapping(value={"/contenttrees"}, method={RequestMethod.GET})
    public String list(Model model, @PageableDefault(sort={"lastModified"}, size=25) Pageable pageable) {
        PageRequest pageRequest = PageableConverter.convert((Pageable)pageable);
        PageResponse pageResponse = this.contentTreeService.find(pageRequest);
        Page page = PageConverter.convert((PageResponse)pageResponse, (PageRequest)pageRequest);
        model.addAttribute("page", (Object)new PageWrapper(page, "/contenttrees"));
        return "contenttrees/list";
    }

    @RequestMapping(value={"/contenttrees/{uuid}"}, method={RequestMethod.GET})
    public String view(@PathVariable UUID uuid, Model model) {
        ContentTree contentTree = (ContentTree)this.contentTreeService.get(uuid);
        model.addAttribute("availableLocales", (Object)contentTree.getLabel().getLocales());
        model.addAttribute("contentTree", (Object)contentTree);
        return "contenttrees/view";
    }

    public void setService(ContentTreeService contentTreeService) {
        this.contentTreeService = contentTreeService;
    }
}

