/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity.parts;

import de.digitalcollections.commons.springdata.domain.PageConverter;
import de.digitalcollections.commons.springdata.domain.PageWrapper;
import de.digitalcollections.commons.springdata.domain.PageableConverter;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.business.api.service.LocaleService;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.entity.parts.ContentNodeService;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.parts.ContentNode;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.parts.ContentNodeImpl;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@SessionAttributes(value={"contentNode"})
public class ContentNodesController
extends AbstractController
implements MessageSourceAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentNodesController.class);
    private MessageSource messageSource;
    @Autowired
    LocaleService localeService;
    @Autowired
    ContentNodeService contentNodeService;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "contentnodes";
    }

    @RequestMapping(value={"/contentnodes/new"}, method={RequestMethod.GET})
    public String create(Model model, @RequestParam(value="parentType") String parentType, @RequestParam(value="parentUuid") String parentUuid) {
        Locale defaultLocale = this.localeService.getDefault();
        List locales = this.localeService.findAll().stream().filter(locale -> !defaultLocale.equals(locale) && !locale.getDisplayName().isEmpty()).sorted(Comparator.comparing(locale -> locale.getDisplayName(LocaleContextHolder.getLocale()))).collect(Collectors.toList());
        model.addAttribute("contentNode", (Object)this.contentNodeService.create());
        model.addAttribute("defaultLocale", (Object)defaultLocale);
        model.addAttribute("locales", locales);
        model.addAttribute("parentType", (Object)parentType);
        model.addAttribute("parentUuid", (Object)parentUuid);
        return "contentnodes/create";
    }

    @RequestMapping(value={"/contentnodes/new"}, method={RequestMethod.POST})
    public String create(@ModelAttribute @Valid ContentNodeImpl contentNode, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes, @RequestParam(value="parentType") String parentType, @RequestParam(value="parentUuid") UUID parentUuid) {
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "contentnodes/create";
        }
        ContentNode contentNodeDb = null;
        try {
            if (Objects.equals(parentType, "contentTree")) {
                contentNodeDb = this.contentNodeService.saveWithParentContentTree((ContentNode)contentNode, parentUuid, (Errors)results);
                LOGGER.info("Successfully saved top-level content node");
            } else if (Objects.equals(parentType, "contentNode")) {
                contentNodeDb = this.contentNodeService.saveWithParentContentNode((ContentNode)contentNode, parentUuid, (Errors)results);
                LOGGER.info("Successfully saved content node");
            }
        }
        catch (Exception e) {
            if (Objects.equals(parentType, "contentTree")) {
                LOGGER.info("Cannot save top-level content node: ", (Throwable)e);
            } else if (Objects.equals(parentType, "contentNode")) {
                LOGGER.error("Cannot save content node: ", (Throwable)e);
            }
            String message = this.messageSource.getMessage("msg.error", null, LocaleContextHolder.getLocale());
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/contenttrees";
        }
        if (results.hasErrors()) {
            return "contentNodes/create";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.created_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/contentnodes/" + contentNodeDb.getUuid().toString();
    }

    @RequestMapping(value={"/contentnodes/{uuid}/edit"}, method={RequestMethod.GET})
    public String edit(@PathVariable UUID uuid, Model model, RedirectAttributes redirectAttributes) {
        ContentNode contentNode = (ContentNode)this.contentNodeService.get(uuid);
        HashSet availableLocales = (HashSet)contentNode.getLabel().getLocales();
        Set availableLocaleTags = availableLocales.stream().map(Locale::toLanguageTag).collect(Collectors.toSet());
        List locales = this.localeService.findAll().stream().filter(locale -> !availableLocaleTags.contains(locale.toLanguageTag()) && !locale.getDisplayName().isEmpty()).sorted(Comparator.comparing(locale -> locale.getDisplayName(LocaleContextHolder.getLocale()))).collect(Collectors.toList());
        model.addAttribute("contentNode", (Object)contentNode);
        model.addAttribute("availableLocales", (Object)availableLocales);
        model.addAttribute("locales", locales);
        return "contentnodes/edit";
    }

    @RequestMapping(value={"/contentnodes/{uuid}/edit"}, method={RequestMethod.POST})
    public String edit(@PathVariable UUID uuid, @ModelAttribute @Valid ContentNodeImpl contentNode, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "contentnodes/edit";
        }
        try {
            ContentNode contentNodeDb = (ContentNode)this.contentNodeService.get(uuid);
            contentNodeDb.setLabel(contentNode.getLabel());
            contentNodeDb.setDescription(contentNode.getDescription());
            this.contentNodeService.update((Identifiable)contentNodeDb, (Errors)results);
        }
        catch (IdentifiableServiceException e) {
            String message = "Cannot save content node with uuid=" + uuid + ": " + (Object)((Object)e);
            LOGGER.error(message, (Throwable)e);
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/contentnodes/" + uuid + "/edit";
        }
        if (results.hasErrors()) {
            return "contentnodes/edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changes_saved_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/contentnodes/" + uuid;
    }

    @RequestMapping(value={"/contentnodes"}, method={RequestMethod.GET})
    public String list(Model model, @PageableDefault(sort={"uuid"}) Pageable pageable) {
        PageRequest pageRequest = PageableConverter.convert((Pageable)pageable);
        PageResponse pageResponse = this.contentNodeService.find(pageRequest);
        Page page = PageConverter.convert((PageResponse)pageResponse, (PageRequest)pageRequest);
        model.addAttribute("page", (Object)new PageWrapper(page, "/contentnodes"));
        return "contentnodes/list";
    }

    @RequestMapping(value={"/contentnodes/{uuid}"}, method={RequestMethod.GET})
    public String view(@PathVariable UUID uuid, Model model) {
        ContentNode contentNode = (ContentNode)this.contentNodeService.get(uuid);
        model.addAttribute("availableLocales", (Object)contentNode.getLabel().getLocales());
        model.addAttribute("defaultLocale", (Object)this.localeService.getDefault());
        model.addAttribute("contentNode", (Object)contentNode);
        return "contentnodes/view";
    }

    @RequestMapping(value={"/contentnodes/{uuid}/identifiables"}, method={RequestMethod.POST})
    public String addIdentifiable(@PathVariable UUID uuid, @RequestParam(name="identifiableUuid") UUID identifiableUuid, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        this.contentNodeService.addIdentifiable(uuid, identifiableUuid);
        return "redirect:/contentnodes/" + uuid;
    }

    public void setContentNodeService(ContentNodeService contentNodeService) {
        this.contentNodeService = contentNodeService;
    }
}

