/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.resource;

import de.digitalcollections.commons.file.business.api.FileResourceService;
import de.digitalcollections.commons.springdata.domain.PageConverter;
import de.digitalcollections.commons.springdata.domain.PageWrapper;
import de.digitalcollections.commons.springdata.domain.PageableConverter;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.business.api.service.LocaleService;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.resource.CudamiFileResourceService;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.MimeType;
import de.digitalcollections.model.api.identifiable.resource.enums.FileResourcePersistenceType;
import de.digitalcollections.model.api.identifiable.resource.exceptions.ResourceIOException;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.resource.FileResourceImpl;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@SessionAttributes(value={"fileresource"})
public class FileResourcesController
extends AbstractController
implements MessageSourceAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileResourcesController.class);
    private MessageSource messageSource;
    @Autowired
    FileResourceService fileResourceService;
    @Autowired
    LocaleService localeService;
    @Autowired
    CudamiFileResourceService<FileResource> cudamiFileResourceService;

    @Autowired
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @GetMapping(value={"/fileresources"})
    public String list(Model model, @PageableDefault(sort={"label"}, size=25) Pageable pageable) {
        PageRequest pageRequest = PageableConverter.convert((Pageable)pageable);
        PageResponse pageResponse = this.cudamiFileResourceService.find(pageRequest);
        Page page = PageConverter.convert((PageResponse)pageResponse, (PageRequest)pageRequest);
        model.addAttribute("page", (Object)new PageWrapper(page, "/fileresources"));
        return "fileresources/list";
    }

    @GetMapping(value={"/fileresources/new"})
    public String create(Model model) {
        Locale defaultLocale = this.localeService.getDefault();
        List locales = this.localeService.findAll().stream().filter(locale -> !defaultLocale.equals(locale) && !locale.getDisplayName().isEmpty()).sorted(Comparator.comparing(locale -> locale.getDisplayName(LocaleContextHolder.getLocale()))).collect(Collectors.toList());
        model.addAttribute("defaultLocale", (Object)defaultLocale);
        model.addAttribute("fileresource", (Object)this.cudamiFileResourceService.create());
        model.addAttribute("locales", locales);
        return "fileresources/create";
    }

    @PostMapping(value={"/fileresources/new"})
    public String create(@ModelAttribute @Valid FileResourceImpl fileResource, BindingResult results, @RequestParam(value="file") MultipartFile file, RedirectAttributes redirectAttributes) {
        if (!file.isEmpty()) {
            try {
                FileResource managedFileResource;
                String contentType = file.getContentType();
                MimeType mimeType = MimeType.fromTypename((String)contentType);
                try {
                    managedFileResource = this.fileResourceService.create(null, FileResourcePersistenceType.MANAGED, mimeType);
                    managedFileResource.setLabel(fileResource.getLabel());
                    managedFileResource.setDescription(fileResource.getDescription());
                }
                catch (ResourceIOException ex) {
                    LOGGER.error("Error creating file resource", (Throwable)ex);
                    redirectAttributes.addFlashAttribute("message", (Object)"Error creating file resource!");
                    return "redirect:/fileresources";
                }
                managedFileResource.setMimeType(mimeType);
                LOGGER.info("mimetype = " + managedFileResource.getMimeType().getTypeName());
                long size = file.getSize();
                managedFileResource.setSizeInBytes(size);
                LOGGER.info("filesize = " + managedFileResource.getSizeInBytes());
                String originalFilename = file.getOriginalFilename();
                managedFileResource.setFilename(originalFilename);
                LOGGER.info("filename = " + managedFileResource.getFilename());
                byte[] bytes = file.getBytes();
                try {
                    this.cudamiFileResourceService.save(managedFileResource, bytes, (Errors)results);
                    redirectAttributes.addFlashAttribute("message", (Object)("You successfully uploaded " + file.getOriginalFilename() + "!"));
                    return "redirect:/fileresources";
                }
                catch (IdentifiableServiceException ex) {
                    LOGGER.error("Error saving uploaded file data", (Throwable)ex);
                    redirectAttributes.addFlashAttribute("message", (Object)"Error saving file resource!");
                    return "redirect:/fileresources";
                }
            }
            catch (IOException ex) {
                LOGGER.error("Error saving uploaded file data", (Throwable)ex);
            }
        }
        redirectAttributes.addFlashAttribute("message", (Object)"Invalid file resource!");
        return "redirect:/fileresources";
    }

    @GetMapping(value={"/fileresources/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) {
        FileResource resource = (FileResource)this.cudamiFileResourceService.get(uuid);
        model.addAttribute("availableLocales", (Object)resource.getLabel().getLocales());
        model.addAttribute("defaultLocale", (Object)this.localeService.getDefault());
        model.addAttribute("fileresource", (Object)resource);
        return "fileresources/view";
    }

    @GetMapping(value={"/fileresources/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, Model model, RedirectAttributes redirectAttributes) {
        FileResource fileresource = (FileResource)this.cudamiFileResourceService.get(uuid);
        HashSet availableLocales = (HashSet)fileresource.getLabel().getLocales();
        Set availableLocaleTags = availableLocales.stream().map(Locale::toLanguageTag).collect(Collectors.toSet());
        List locales = this.localeService.findAll().stream().filter(locale -> !availableLocaleTags.contains(locale.toLanguageTag()) && !locale.getDisplayName().isEmpty()).sorted(Comparator.comparing(locale -> locale.getDisplayName(LocaleContextHolder.getLocale()))).collect(Collectors.toList());
        model.addAttribute("fileresource", (Object)fileresource);
        model.addAttribute("availableLocales", (Object)availableLocales);
        model.addAttribute("locales", locales);
        return "fileresources/edit";
    }

    @PostMapping(value={"/fileresources/{pathUuid}/edit"})
    public String edit(@PathVariable UUID pathUuid, @ModelAttribute @Valid FileResourceImpl fileResource, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "fileresources/edit";
        }
        try {
            FileResource fileResourceDb = (FileResource)this.cudamiFileResourceService.get(pathUuid);
            fileResourceDb.setLabel(fileResource.getLabel());
            fileResourceDb.setDescription(fileResource.getDescription());
            this.cudamiFileResourceService.update((Identifiable)fileResourceDb, (Errors)results);
        }
        catch (IdentifiableServiceException e) {
            String message = "Cannot save fileresource with uuid=" + pathUuid + ": " + (Object)((Object)e);
            LOGGER.error(message, (Throwable)e);
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/fileresources/" + pathUuid + "/edit";
        }
        if (results.hasErrors()) {
            return "fileresources/edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changes_saved_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/fileresources/" + pathUuid;
    }
}

