/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springdata.domain.PageConverter;
import de.digitalcollections.commons.springdata.domain.PageWrapper;
import de.digitalcollections.commons.springdata.domain.PageableConverter;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.client.CudamiCollectionsClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.entity.Collection;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class CollectionsController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionsController.class);
    LocaleRepository localeRepository;
    CudamiCollectionsClient cudamiCollectionsClient;

    @Autowired
    public CollectionsController(LocaleRepository localeRepository, CudamiCollectionsClient cudamiCollectionsClient) {
        this.localeRepository = localeRepository;
        this.cudamiCollectionsClient = cudamiCollectionsClient;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "collections";
    }

    @GetMapping(value={"/collections/new"})
    public String create(Model model) {
        model.addAttribute("activeLanguage", (Object)this.localeRepository.getDefaultLanguage());
        return "collections/create";
    }

    @GetMapping(value={"/api/collections/new"})
    @ResponseBody
    public Collection create() {
        return this.cudamiCollectionsClient.createCollection();
    }

    @GetMapping(value={"/collections/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, Model model) throws HttpException {
        Collection collection = this.cudamiCollectionsClient.getCollection(uuid);
        model.addAttribute("activeLanguage", (Object)this.localeRepository.getDefaultLanguage());
        model.addAttribute("uuid", (Object)collection.getUuid());
        return "collections/edit";
    }

    @GetMapping(value={"/api/collections/{uuid}"})
    @ResponseBody
    public Collection get(@PathVariable UUID uuid) throws HttpException {
        return this.cudamiCollectionsClient.getCollection(uuid);
    }

    @GetMapping(value={"/collections"})
    public String list(Model model, @PageableDefault(sort={"label"}, size=25) Pageable pageable) {
        PageRequest pageRequest = PageableConverter.convert((Pageable)pageable);
        PageResponse pageResponse = this.cudamiCollectionsClient.findCollections(pageRequest);
        Page page = PageConverter.convert((PageResponse)pageResponse, (PageRequest)pageRequest);
        model.addAttribute("page", (Object)new PageWrapper(page, "/collections"));
        return "collections/list";
    }

    @PostMapping(value={"/api/collections/new"})
    public ResponseEntity save(@RequestBody Collection collection) throws IdentifiableServiceException {
        try {
            Collection collectionDb = this.cudamiCollectionsClient.saveCollection(collection);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)collectionDb);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save collection: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/collections/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Collection collection) throws IdentifiableServiceException {
        try {
            Collection collectionDb = this.cudamiCollectionsClient.updateCollection(collection);
            return ResponseEntity.ok((Object)collectionDb);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save collection with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/collections/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) throws HttpException {
        Collection collection = this.cudamiCollectionsClient.getCollection(uuid);
        model.addAttribute("availableLanguages", (Object)collection.getLabel().getLocales());
        model.addAttribute("collection", (Object)collection);
        return "collections/view";
    }
}

