/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springdata.domain.PageConverter;
import de.digitalcollections.commons.springdata.domain.PageWrapper;
import de.digitalcollections.commons.springdata.domain.PageableConverter;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.client.CudamiCorporationsClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.entity.Corporation;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class CorporationsController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CorporationsController.class);
    LocaleRepository localeRepository;
    CudamiCorporationsClient cudamiCorporationsClient;

    @Autowired
    public CorporationsController(LocaleRepository localeRepository, CudamiCorporationsClient cudamiCorporationsClient) {
        this.localeRepository = localeRepository;
        this.cudamiCorporationsClient = cudamiCorporationsClient;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "corporations";
    }

    @GetMapping(value={"/corporations/new"})
    public String create(Model model) {
        model.addAttribute("activeLanguage", (Object)this.localeRepository.getDefaultLanguage());
        return "corporations/create";
    }

    @GetMapping(value={"/api/corporations/new"})
    @ResponseBody
    public Corporation create() {
        return this.cudamiCorporationsClient.createCorporation();
    }

    @GetMapping(value={"/corporations/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, Model model) throws HttpException {
        Corporation corporation = this.cudamiCorporationsClient.getCorporation(uuid);
        model.addAttribute("activeLanguage", (Object)this.localeRepository.getDefaultLanguage());
        model.addAttribute("uuid", (Object)corporation.getUuid());
        return "corporations/edit";
    }

    @GetMapping(value={"/api/corporations/{uuid}"})
    @ResponseBody
    public Corporation get(@PathVariable UUID uuid) throws HttpException {
        return this.cudamiCorporationsClient.getCorporation(uuid);
    }

    @GetMapping(value={"/corporations"})
    public String list(Model model, @PageableDefault(sort={"label"}, size=25) Pageable pageable) {
        PageRequest pageRequest = PageableConverter.convert((Pageable)pageable);
        PageResponse pageResponse = this.cudamiCorporationsClient.findCorporations(pageRequest);
        Page page = PageConverter.convert((PageResponse)pageResponse, (PageRequest)pageRequest);
        model.addAttribute("page", (Object)new PageWrapper(page, "/corporations"));
        return "corporations/list";
    }

    @PostMapping(value={"/api/corporations/new"})
    public ResponseEntity save(@RequestBody Corporation corporation) throws IdentifiableServiceException {
        try {
            Corporation corporationDb = this.cudamiCorporationsClient.saveCorporation(corporation);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)corporationDb);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save corporation: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/corporations/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Corporation corporation) throws IdentifiableServiceException {
        try {
            Corporation corporationDb = this.cudamiCorporationsClient.updateCorporation(corporation);
            return ResponseEntity.ok((Object)corporationDb);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save corporation with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/corporations/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) throws HttpException {
        Corporation corporation = this.cudamiCorporationsClient.getCorporation(uuid);
        model.addAttribute("availableLanguages", (Object)corporation.getLabel().getLocales());
        model.addAttribute("corporation", (Object)corporation);
        return "corporations/view";
    }
}

