/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springdata.domain.PageConverter;
import de.digitalcollections.commons.springdata.domain.PageWrapper;
import de.digitalcollections.commons.springdata.domain.PageableConverter;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.client.CudamiProjectsClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.entity.Project;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ProjectsController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectsController.class);
    LocaleRepository localeRepository;
    CudamiProjectsClient cudamiProjectsClient;

    @Autowired
    public ProjectsController(LocaleRepository localeRepository, CudamiProjectsClient cudamiProjectsClient) {
        this.localeRepository = localeRepository;
        this.cudamiProjectsClient = cudamiProjectsClient;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "projects";
    }

    @GetMapping(value={"/projects/new"})
    public String create(Model model) {
        model.addAttribute("activeLanguage", (Object)this.localeRepository.getDefaultLanguage());
        return "projects/create";
    }

    @GetMapping(value={"/api/projects/new"})
    @ResponseBody
    public Project create() {
        return this.cudamiProjectsClient.createProject();
    }

    @GetMapping(value={"/projects/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, Model model) throws HttpException {
        Project project = this.cudamiProjectsClient.getProject(uuid);
        model.addAttribute("activeLanguage", (Object)this.localeRepository.getDefaultLanguage());
        model.addAttribute("uuid", (Object)project.getUuid());
        return "projects/edit";
    }

    @GetMapping(value={"/api/projects/{uuid}"})
    @ResponseBody
    public Project get(@PathVariable UUID uuid) throws HttpException {
        return this.cudamiProjectsClient.getProject(uuid);
    }

    @GetMapping(value={"/projects"})
    public String list(Model model, @PageableDefault(sort={"label"}, size=25) Pageable pageable) {
        PageRequest pageRequest = PageableConverter.convert((Pageable)pageable);
        PageResponse pageResponse = this.cudamiProjectsClient.findProjects(pageRequest);
        Page page = PageConverter.convert((PageResponse)pageResponse, (PageRequest)pageRequest);
        model.addAttribute("page", (Object)new PageWrapper(page, "/projects"));
        return "projects/list";
    }

    @PostMapping(value={"/api/projects/new"})
    public ResponseEntity save(@RequestBody Project project) throws IdentifiableServiceException {
        try {
            Project projectDb = this.cudamiProjectsClient.saveProject(project);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)projectDb);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save project: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/projects/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Project project) throws IdentifiableServiceException {
        try {
            Project projectDb = this.cudamiProjectsClient.updateProject(project);
            return ResponseEntity.ok((Object)projectDb);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save project with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/projects/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) throws HttpException {
        Project project = this.cudamiProjectsClient.getProject(uuid);
        model.addAttribute("availableLanguages", (Object)project.getLabel().getLocales());
        model.addAttribute("project", (Object)project);
        return "projects/view";
    }
}

