/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springdata.domain.PageConverter;
import de.digitalcollections.commons.springdata.domain.PageWrapper;
import de.digitalcollections.commons.springdata.domain.PageableConverter;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.entity.WebsiteService;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.Website;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WebsitesController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsitesController.class);
    LocaleRepository localeRepository;
    WebsiteService service;

    @Autowired
    public WebsitesController(LocaleRepository localeRepository, WebsiteService service) {
        this.localeRepository = localeRepository;
        this.service = service;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "websites";
    }

    @GetMapping(value={"/websites/new"})
    public String create(Model model) {
        model.addAttribute("activeLanguage", (Object)this.localeRepository.getDefaultLanguage());
        return "websites/create";
    }

    @GetMapping(value={"/api/websites/new"})
    @ResponseBody
    public Website create() {
        return (Website)this.service.create();
    }

    @GetMapping(value={"/websites/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, Model model) {
        Website website = (Website)this.service.get(uuid);
        model.addAttribute("activeLanguage", (Object)this.localeRepository.getDefaultLanguage());
        model.addAttribute("url", (Object)website.getUrl());
        model.addAttribute("uuid", (Object)website.getUuid());
        return "websites/edit";
    }

    @GetMapping(value={"/api/websites/{uuid}"})
    @ResponseBody
    public Website get(@PathVariable UUID uuid) {
        return (Website)this.service.get(uuid);
    }

    @GetMapping(value={"/websites"})
    public String list(Model model, @PageableDefault(sort={"email"}, size=25) Pageable pageable) {
        PageRequest pageRequest = PageableConverter.convert((Pageable)pageable);
        PageResponse pageResponse = this.service.find(pageRequest);
        Page page = PageConverter.convert((PageResponse)pageResponse, (PageRequest)pageRequest);
        model.addAttribute("page", (Object)new PageWrapper(page, "/websites"));
        return "websites/list";
    }

    @PostMapping(value={"/api/websites/new"})
    public ResponseEntity save(@RequestBody Website website) throws IdentifiableServiceException {
        try {
            Website websiteDb = (Website)this.service.save((Identifiable)website);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)websiteDb);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save website: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/websites/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Website website) throws IdentifiableServiceException {
        try {
            Website websiteDb = (Website)this.service.update((Identifiable)website);
            return ResponseEntity.ok((Object)websiteDb);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save website with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/websites/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) {
        Website website = (Website)this.service.get(uuid);
        model.addAttribute("availableLanguages", (Object)website.getLabel().getLocales());
        model.addAttribute("website", (Object)website);
        return "websites/view";
    }
}

