/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.resource;

import de.digitalcollections.commons.springdata.domain.PageConverter;
import de.digitalcollections.commons.springdata.domain.PageWrapper;
import de.digitalcollections.commons.springdata.domain.PageableConverter;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.resource.CudamiFileResourceService;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.tomcat.util.http.fileupload.FileItemIterator;
import org.apache.tomcat.util.http.fileupload.FileItemStream;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class FileResourcesController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileResourcesController.class);
    LocaleRepository localeRepository;
    CudamiFileResourceService service;

    @Autowired
    public FileResourcesController(LocaleRepository localeRepository, CudamiFileResourceService service) {
        this.localeRepository = localeRepository;
        this.service = service;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "fileresources";
    }

    @GetMapping(value={"/fileresources/new"})
    public String create(Model model) {
        model.addAttribute("activeLanguage", (Object)this.localeRepository.getDefaultLanguage());
        return "fileresources/create";
    }

    @GetMapping(value={"/api/fileresources/new"})
    @ResponseBody
    public FileResource create() {
        return (FileResource)this.service.create();
    }

    @GetMapping(value={"/fileresources/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, Model model) {
        FileResource fileResource = (FileResource)this.service.get(uuid);
        model.addAttribute("activeLanguage", (Object)this.localeRepository.getDefaultLanguage());
        model.addAttribute("filename", (Object)fileResource.getFilename());
        model.addAttribute("uuid", (Object)fileResource.getUuid());
        return "fileresources/edit";
    }

    @GetMapping(value={"/api/fileresources/{uuid}"})
    @ResponseBody
    public FileResource get(@PathVariable UUID uuid) {
        return (FileResource)this.service.get(uuid);
    }

    @GetMapping(value={"/fileresources"})
    public String list(Model model, @PageableDefault(sort={"label"}, size=25) Pageable pageable) {
        PageRequest pageRequest = PageableConverter.convert((Pageable)pageable);
        PageResponse pageResponse = this.service.find(pageRequest);
        Page page = PageConverter.convert((PageResponse)pageResponse, (PageRequest)pageRequest);
        model.addAttribute("page", (Object)new PageWrapper(page, "/fileresources"));
        return "fileresources/list";
    }

    @PostMapping(value={"/api/fileresources/new"})
    public ResponseEntity save(@RequestBody FileResource fileResource) throws IdentifiableServiceException {
        try {
            FileResource fileResourceDb = (FileResource)this.service.save((Identifiable)fileResource);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)fileResourceDb);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save fileresource: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/fileresources/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody FileResource fileResource) throws IdentifiableServiceException {
        try {
            FileResource fileResourceDb = (FileResource)this.service.update((Identifiable)fileResource);
            return ResponseEntity.ok((Object)fileResourceDb);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save fileresource with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api/fileresources/new/upload"})
    @ResponseBody
    public FileResource upload(HttpServletRequest request, RedirectAttributes redirectAttributes) throws InterruptedException, IOException {
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (!isMultipart) {
            redirectAttributes.addFlashAttribute("message", (Object)"Invalid file resource!");
            return null;
        }
        try (InputStream stream = null;){
            ServletFileUpload upload = new ServletFileUpload();
            FileItemIterator iter = upload.getItemIterator(request);
            while (iter.hasNext()) {
                FileResource fileResource;
                FileItemStream item = iter.next();
                if (item.isFormField()) continue;
                String contentType = item.getContentType();
                String filename = item.getName();
                stream = item.openStream();
                FileResource fileResource2 = fileResource = this.service.upload(stream, filename, contentType);
                return fileResource2;
            }
        }
        LOGGER.warn("Invalid file resource!");
        return null;
    }

    @GetMapping(value={"/fileresources/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) {
        FileResource resource = (FileResource)this.service.get(uuid);
        model.addAttribute("availableLanguages", (Object)resource.getLabel().getLocales());
        model.addAttribute("fileresource", (Object)resource);
        return "fileresources/view";
    }
}

