/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable;

import de.digitalcollections.commons.springdata.domain.PageConverter;
import de.digitalcollections.commons.springdata.domain.PageWrapper;
import de.digitalcollections.commons.springdata.domain.PageableConverter;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.IdentifierTypeService;
import de.digitalcollections.model.api.identifiable.IdentifierType;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifierTypeImpl;
import java.util.UUID;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@SessionAttributes(value={"identifierType"})
public class IdentifierTypeController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifierTypeController.class);
    private final MessageSource messageSource;
    IdentifierTypeService service;

    @Autowired
    public IdentifierTypeController(MessageSource messageSource, IdentifierTypeService service) {
        this.messageSource = messageSource;
        this.service = service;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "identifiertypes";
    }

    @RequestMapping(value={"/identifiertypes/new"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("identifierType", (Object)this.service.create());
        return "identifiertypes/create";
    }

    @RequestMapping(value={"/identifiertypes/new"}, method={RequestMethod.POST})
    public String create(@ModelAttribute @Valid IdentifierTypeImpl identifierType, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "identifiertypes/create";
        }
        try {
            this.service.save((IdentifierType)identifierType);
            LOGGER.info("Successfully saved identifier type");
        }
        catch (Exception e) {
            LOGGER.error("Cannot save identifier type: ", (Throwable)e);
            String message = this.messageSource.getMessage("msg.error", null, LocaleContextHolder.getLocale());
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/identifiertypes";
        }
        if (results.hasErrors()) {
            return "identifiertypes/create";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.created_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/identifiertypes";
    }

    @RequestMapping(value={"/identifiertypes/{uuid}/edit"}, method={RequestMethod.GET})
    public String edit(@PathVariable UUID uuid, Model model, RedirectAttributes redirectAttributes) {
        model.addAttribute("identifierType", (Object)this.service.get(uuid));
        return "identifiertypes/edit";
    }

    @RequestMapping(value={"/identifiertypes/{pathUuid}/edit"}, method={RequestMethod.POST})
    public String edit(@PathVariable UUID pathUuid, @ModelAttribute @Valid IdentifierTypeImpl identifierType, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "identifiertypes/" + pathUuid + "/edit";
        }
        try {
            IdentifierType identifierTypeDb = this.service.get(pathUuid);
            identifierTypeDb.setLabel(identifierType.getLabel());
            identifierTypeDb.setNamespace(identifierType.getNamespace());
            identifierTypeDb.setPattern(identifierType.getPattern());
            this.service.update(identifierTypeDb);
        }
        catch (Exception e) {
            String message = "Cannot save identifier type with uuid=" + pathUuid + ": " + e;
            LOGGER.error(message, (Throwable)e);
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/identifiertypes/" + pathUuid + "/edit";
        }
        if (results.hasErrors()) {
            return "identifiertypes/" + pathUuid + "/edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changes_saved_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/identifiertypes";
    }

    @GetMapping(value={"/identifiertypes"})
    public String list(Model model, @PageableDefault(sort={"lastModified"}, size=25) Pageable pageable) {
        PageRequest pageRequest = PageableConverter.convert((Pageable)pageable);
        PageResponse pageResponse = this.service.find(pageRequest);
        Page page = PageConverter.convert((PageResponse)pageResponse, (PageRequest)pageRequest);
        model.addAttribute("page", (Object)new PageWrapper(page, "/identifiertypes"));
        return "identifiertypes/list";
    }
}

