/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springdata.domain.PageConverter;
import de.digitalcollections.commons.springdata.domain.PageWrapper;
import de.digitalcollections.commons.springdata.domain.PageableConverter;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.entity.ContentTreeService;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.ContentTree;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ContentTreesController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentTreesController.class);
    LanguageSortingHelper languageSortingHelper;
    LocaleRepository localeRepository;
    ContentTreeService service;

    @Autowired
    public ContentTreesController(LanguageSortingHelper languageSortingHelper, LocaleRepository localeRepository, ContentTreeService service) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeRepository = localeRepository;
        this.service = service;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "contenttrees";
    }

    @GetMapping(value={"/contenttrees/new"})
    public String create(Model model) {
        model.addAttribute("activeLanguage", (Object)this.localeRepository.getDefaultLanguage());
        return "contenttrees/create";
    }

    @GetMapping(value={"/api/contenttrees/new"})
    @ResponseBody
    public ContentTree create() {
        return (ContentTree)this.service.create();
    }

    @GetMapping(value={"/contenttrees/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, Model model) {
        Locale displayLocale = LocaleContextHolder.getLocale();
        ContentTree contentTree = (ContentTree)this.service.get(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, contentTree.getLabel().getLocales());
        model.addAttribute("activeLanguage", existingLanguages.get(0));
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("uuid", (Object)contentTree.getUuid());
        return "contenttrees/edit";
    }

    @GetMapping(value={"/api/contenttrees/{uuid}"})
    @ResponseBody
    public ContentTree get(@PathVariable UUID uuid) {
        return (ContentTree)this.service.get(uuid);
    }

    @GetMapping(value={"/contenttrees"})
    public String list(Model model, @PageableDefault(sort={"lastModified"}, size=25) Pageable pageable) {
        PageRequest pageRequest = PageableConverter.convert((Pageable)pageable);
        PageResponse pageResponse = this.service.find(pageRequest);
        Page page = PageConverter.convert((PageResponse)pageResponse, (PageRequest)pageRequest);
        model.addAttribute("page", (Object)new PageWrapper(page, "/contenttrees"));
        return "contenttrees/list";
    }

    @PostMapping(value={"/api/contenttrees/new"})
    public ResponseEntity save(@RequestBody ContentTree contentTree) throws IdentifiableServiceException {
        try {
            ContentTree contentTreeDb = (ContentTree)this.service.save((Identifiable)contentTree);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)contentTreeDb);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save content tree: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/contenttrees/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody ContentTree contentTree) throws IdentifiableServiceException {
        try {
            ContentTree contentTreeDb = (ContentTree)this.service.update((Identifiable)contentTree);
            return ResponseEntity.ok((Object)contentTreeDb);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save content tree with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/contenttrees/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) {
        Locale displayLocale = LocaleContextHolder.getLocale();
        ContentTree contentTree = (ContentTree)this.service.get(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, contentTree.getLabel().getLocales());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("contentTree", (Object)contentTree);
        return "contenttrees/view";
    }
}

