/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity.parts;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.entity.parts.ContentNodeService;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.parts.ContentNode;
import de.digitalcollections.model.api.identifiable.entity.parts.EntityPart;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ContentNodesController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentNodesController.class);
    LanguageSortingHelper languageSortingHelper;
    LocaleRepository localeRepository;
    ContentNodeService service;

    @Autowired
    public ContentNodesController(LanguageSortingHelper languageSortingHelper, LocaleRepository localeRepository, ContentNodeService service) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeRepository = localeRepository;
        this.service = service;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "contentnodes";
    }

    @GetMapping(value={"/contentnodes/new"})
    public String create(Model model, @RequestParam(value="parentType") String parentType, @RequestParam(value="parentUuid") String parentUuid) {
        model.addAttribute("activeLanguage", (Object)this.localeRepository.getDefaultLanguage());
        model.addAttribute("parentType", (Object)parentType);
        model.addAttribute("parentUuid", (Object)parentUuid);
        return "contentnodes/create";
    }

    @GetMapping(value={"/api/contentnodes/new"})
    @ResponseBody
    public ContentNode create() {
        return (ContentNode)this.service.create();
    }

    @GetMapping(value={"/contentnodes/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, Model model) {
        Locale displayLocale = LocaleContextHolder.getLocale();
        ContentNode contentNode = (ContentNode)this.service.get(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, contentNode.getLabel().getLocales());
        model.addAttribute("activeLanguage", existingLanguages.get(0));
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("uuid", (Object)contentNode.getUuid());
        return "contentnodes/edit";
    }

    @GetMapping(value={"/api/contentnodes/{uuid}"})
    @ResponseBody
    public ContentNode get(@PathVariable UUID uuid) {
        return (ContentNode)this.service.get(uuid);
    }

    @PostMapping(value={"/api/contentnodes/new"})
    public ResponseEntity save(@RequestBody ContentNode contentNode, @RequestParam(value="parentType") String parentType, @RequestParam(value="parentUuid") UUID parentUuid) throws IdentifiableServiceException {
        try {
            ContentNode contentNodeDb = null;
            contentNodeDb = parentType.equals("contentTree") ? this.service.saveWithParentContentTree(contentNode, parentUuid) : this.service.saveWithParentContentNode(contentNode, parentUuid);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)contentNodeDb);
        }
        catch (Exception e) {
            if (parentType.equals("contentTree")) {
                LOGGER.error("Cannot save top-level content node: ", (Throwable)e);
            } else if (parentType.equals("contentNode")) {
                LOGGER.error("Cannot save content node: ", (Throwable)e);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/contentnodes/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody ContentNode contentNode) throws IdentifiableServiceException {
        try {
            ContentNode contentNodeDb = (ContentNode)this.service.update((Identifiable)contentNode);
            return ResponseEntity.ok((Object)contentNodeDb);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save content node with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/contentnodes/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) {
        Locale displayLocale = LocaleContextHolder.getLocale();
        ContentNode contentNode = (ContentNode)this.service.get(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, contentNode.getLabel().getLocales());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("contentNode", (Object)contentNode);
        LinkedHashSet relatedFileResources = this.service.getRelatedFileResources((EntityPart)contentNode);
        model.addAttribute("relatedFileResources", (Object)relatedFileResources);
        return "contentnodes/view";
    }
}

