/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.security;

import de.digitalcollections.commons.springdata.domain.PageConverter;
import de.digitalcollections.commons.springdata.domain.PageWrapper;
import de.digitalcollections.commons.springdata.domain.PageableConverter;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.business.api.service.security.UserService;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.security.User;
import de.digitalcollections.model.api.security.enums.Role;
import de.digitalcollections.model.impl.security.UserImpl;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@SessionAttributes(value={"user"})
public class UserController
extends AbstractController {
    private final MessageSource messageSource;
    UserService service;

    @Autowired
    public UserController(MessageSource messageSource, UserService service) {
        this.messageSource = messageSource;
        this.service = service;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "users";
    }

    @ModelAttribute(value="allRoles")
    protected List<Role> populateAllRoles() {
        return Arrays.asList(Role.values());
    }

    @InitBinder(value={"user"})
    protected void initBinder(WebDataBinder binder) {
    }

    @GetMapping(value={"/users/{uuid}/activate"})
    public String activate(@PathVariable UUID uuid, Model model, RedirectAttributes redirectAttributes) {
        User user = this.service.activate(uuid);
        String message = this.messageSource.getMessage("msg.user_activated", new Object[]{user.getEmail()}, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/users";
    }

    @GetMapping(value={"/users/new"})
    public String create(Model model) {
        model.addAttribute("user", (Object)this.service.create());
        return "users/create";
    }

    @PostMapping(value={"/users/new"})
    public String create(@RequestParam(value="pwd1") String password1, @RequestParam(value="pwd2") String password2, @ModelAttribute(name="user") @Valid UserImpl user, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "users/create";
        }
        User userDb = this.service.create((User)user, password1, password2, (Errors)results);
        if (results.hasErrors()) {
            return "users/create";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.created_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/users/" + userDb.getUuid().toString();
    }

    @GetMapping(value={"/users/{uuid}/deactivate"})
    public String deactivate(@PathVariable UUID uuid, Model model, RedirectAttributes redirectAttributes) {
        User user = this.service.deactivate(uuid);
        String message = this.messageSource.getMessage("msg.user_deactivated", new Object[]{user.getEmail()}, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("warning_message", (Object)message);
        return "redirect:/users";
    }

    @GetMapping(value={"/users/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, Model model) {
        model.addAttribute("user", (Object)this.service.findOne(uuid));
        return "users/edit";
    }

    @PostMapping(value={"/users/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(value="pwd1") String password1, @RequestParam(value="pwd2") String password2, @ModelAttribute(name="user") @Valid UserImpl user, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "users/edit";
        }
        this.service.update((User)user, password1, password2, (Errors)results);
        if (results.hasErrors()) {
            return "users/edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changes_saved_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/users/" + uuid;
    }

    @GetMapping(value={"/users"})
    public String list(Model model, @PageableDefault(sort={"email"}, size=25) Pageable pageable) {
        PageRequest pageRequest = PageableConverter.convert((Pageable)pageable);
        PageResponse pageResponse = this.service.find(pageRequest);
        Page page = PageConverter.convert((PageResponse)pageResponse, (PageRequest)pageRequest);
        model.addAttribute("page", (Object)new PageWrapper(page, "/users"));
        return "users/list";
    }

    @GetMapping(value={"/users/updatePassword"})
    public String updatePassword(Model model) {
        User currentUser = this.service.findByEmail(SecurityContextHolder.getContext().getAuthentication().getName());
        model.addAttribute("user", (Object)currentUser);
        return "users/edit-password";
    }

    @PostMapping(value={"/users/updatePassword"})
    public String updatePassword(@RequestParam(value="pwd1") String password1, @RequestParam(value="pwd2") String password2, @ModelAttribute(name="user") @Valid UserImpl user, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "users/updatePassword";
        }
        this.service.update((User)user, password1, password2, (Errors)results);
        if (results.hasErrors()) {
            return "users/updatePassword";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changed_password_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/";
    }

    @GetMapping(value={"/users/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) {
        model.addAttribute("user", (Object)this.service.findOne(uuid));
        return "users/view";
    }
}

