/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.mxab.thymeleaf.extras.dataattribute.dialect.DataAttributeDialect;
import de.digitalcollections.commons.servlet.filter.LogSessionIdFilter;
import de.digitalcollections.commons.springmvc.config.SpringConfigCommonsMvc;
import de.digitalcollections.commons.springmvc.controller.ErrorController;
import de.digitalcollections.commons.springmvc.thymeleaf.SpacesDialect;
import de.digitalcollections.cudami.admin.converter.GrantedAuthorityJsonFilter;
import de.digitalcollections.cudami.admin.interceptors.CreateAdminUserInterceptor;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.model.jackson.DigitalCollectionsObjectMapper;
import java.util.List;
import java.util.Locale;
import javax.servlet.Filter;
import nz.net.ultraq.thymeleaf.LayoutDialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.data.web.config.EnableSpringDataWebSupport;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;
import org.thymeleaf.dialect.AbstractProcessorDialect;
import org.thymeleaf.dialect.springdata.SpringDataDialect;
import org.thymeleaf.extras.springsecurity5.dialect.SpringSecurityDialect;

@Configuration
@ComponentScan(basePackages={"de.digitalcollections.commons.springmvc.controller"}, excludeFilters={@ComponentScan.Filter(value={ErrorController.class}, type=FilterType.ASSIGNABLE_TYPE)})
@EnableAspectJAutoProxy
@EnableSpringDataWebSupport
@Import(value={SpringConfigCommonsMvc.class})
public class SpringConfigWeb
implements WebMvcConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringConfigWeb.class);
    static final String ENCODING = "UTF-8";

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/favicon.ico"}).addResourceLocations(new String[]{"classpath:/static/images/favicon.png"});
    }

    @Bean
    @Primary
    public ObjectMapper objectMapper() {
        DigitalCollectionsObjectMapper objectMapper = new DigitalCollectionsObjectMapper();
        objectMapper.addMixIn(GrantedAuthority.class, GrantedAuthorityJsonFilter.class);
        return objectMapper;
    }

    @Bean
    public DataAttributeDialect dataAttributeDialect() {
        return new DataAttributeDialect();
    }

    @Bean
    public LayoutDialect layoutDialect() {
        return new LayoutDialect();
    }

    @Bean
    public SpringDataDialect springDataDialect() {
        return new SpringDataDialect();
    }

    @Bean
    public AbstractProcessorDialect whiteSpaceNormalizedDialect() {
        return new SpacesDialect();
    }

    @Bean
    public SpringSecurityDialect springSecurityDialect() {
        return new SpringSecurityDialect();
    }

    @Bean
    public LocaleChangeInterceptor localeChangeInterceptor() {
        LocaleChangeInterceptor localeChangeInterceptor = new LocaleChangeInterceptor();
        localeChangeInterceptor.setParamName("language");
        return localeChangeInterceptor;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.localeChangeInterceptor());
        InterceptorRegistration createAdminUserInterceptorRegistration = registry.addInterceptor((HandlerInterceptor)this.createAdminUserInterceptor());
        createAdminUserInterceptorRegistration.addPathPatterns(new String[]{"/login"});
    }

    @Bean
    public SessionLocaleResolver localeResolver() {
        return new SessionLocaleResolver();
    }

    @Bean
    public CreateAdminUserInterceptor createAdminUserInterceptor() {
        return new CreateAdminUserInterceptor();
    }

    public void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
        configurer.enable();
    }

    @Bean
    public FilterRegistrationBean logSessionIdFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new LogSessionIdFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        return registration;
    }

    @Bean
    public LanguageSortingHelper languageSortingHelper(@Value(value="${cudami.prioritisedSortedLanguages}") List<Locale> prioritisedSortedLanguages) {
        return new LanguageSortingHelper(prioritisedSortedLanguages);
    }
}

