/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity.parts;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.entity.parts.SubtopicService;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.Topic;
import de.digitalcollections.model.api.identifiable.entity.parts.Subtopic;
import de.digitalcollections.model.api.view.BreadcrumbNavigation;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SubtopicsController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubtopicsController.class);
    LanguageSortingHelper languageSortingHelper;
    LocaleRepository localeRepository;
    SubtopicService service;

    @Autowired
    public SubtopicsController(LanguageSortingHelper languageSortingHelper, LocaleRepository localeRepository, SubtopicService service) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeRepository = localeRepository;
        this.service = service;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "subtopics";
    }

    @GetMapping(value={"/subtopics/new"})
    public String create(Model model, @RequestParam(value="parentType") String parentType, @RequestParam(value="parentUuid") String parentUuid) {
        model.addAttribute("activeLanguage", (Object)this.localeRepository.getDefaultLanguage());
        model.addAttribute("parentType", (Object)parentType);
        model.addAttribute("parentUuid", (Object)parentUuid);
        return "subtopics/create";
    }

    @GetMapping(value={"/api/subtopics/new"})
    @ResponseBody
    public Subtopic create() {
        return (Subtopic)this.service.create();
    }

    @GetMapping(value={"/subtopics/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, Model model) {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Subtopic subtopic = (Subtopic)this.service.get(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, subtopic.getLabel().getLocales());
        model.addAttribute("activeLanguage", existingLanguages.get(0));
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("uuid", (Object)subtopic.getUuid());
        return "subtopics/edit";
    }

    @GetMapping(value={"/api/subtopics/{uuid}"})
    @ResponseBody
    public Subtopic get(@PathVariable UUID uuid) {
        return (Subtopic)this.service.get(uuid);
    }

    @PostMapping(value={"/api/subtopics/new"})
    public ResponseEntity save(@RequestBody Subtopic subtopic, @RequestParam(value="parentType") String parentType, @RequestParam(value="parentUuid") UUID parentUuid) throws IdentifiableServiceException {
        try {
            Subtopic subtopicDb = null;
            subtopicDb = parentType.equals("topic") ? this.service.saveWithParentTopic(subtopic, parentUuid) : this.service.saveWithParentSubtopic(subtopic, parentUuid);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)subtopicDb);
        }
        catch (Exception e) {
            if (parentType.equals("topic")) {
                LOGGER.error("Cannot save top-level subtopic: ", (Throwable)e);
            } else if (parentType.equals("subtopic")) {
                LOGGER.error("Cannot save subtopic: ", (Throwable)e);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/subtopics/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Subtopic subtopic) throws IdentifiableServiceException {
        try {
            Subtopic subtopicDb = (Subtopic)this.service.update((Identifiable)subtopic);
            return ResponseEntity.ok((Object)subtopicDb);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save subtopic with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/subtopics/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Subtopic subtopic = (Subtopic)this.service.get(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, subtopic.getLabel().getLocales());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("subtopic", (Object)subtopic);
        List relatedFileResources = this.service.getFileResources(subtopic);
        model.addAttribute("relatedFileResources", (Object)relatedFileResources);
        List relatedEntities = this.service.getEntities(subtopic);
        model.addAttribute("relatedEntities", (Object)relatedEntities);
        BreadcrumbNavigation breadcrumbNavigation = this.service.getBreadcrumbNavigation(uuid);
        List breadcrumbs = breadcrumbNavigation.getNavigationItems();
        breadcrumbs.removeIf(n -> n.getUuid() == null);
        model.addAttribute("breadcrumbs", (Object)breadcrumbs);
        Topic topic = this.service.getTopic(uuid);
        model.addAttribute("topic", (Object)topic);
        return "subtopics/view";
    }
}

