/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.resource;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.business.api.service.identifiable.resource.FileResourceBinaryService;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.tomcat.util.http.fileupload.FileItemIterator;
import org.apache.tomcat.util.http.fileupload.FileItemStream;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class FileResourcesBinaryController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileResourcesBinaryController.class);
    FileResourceBinaryService service;

    @Autowired
    public FileResourcesBinaryController(FileResourceBinaryService service) {
        this.service = service;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "fileresources";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api/files"})
    @ResponseBody
    public FileResource upload(HttpServletRequest request, RedirectAttributes redirectAttributes) throws InterruptedException, IOException {
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (!isMultipart) {
            redirectAttributes.addFlashAttribute("message", (Object)"Invalid file resource!");
            return null;
        }
        try (InputStream stream = null;){
            ServletFileUpload upload = new ServletFileUpload();
            FileItemIterator iter = upload.getItemIterator(request);
            while (iter.hasNext()) {
                FileResource fileResource;
                FileItemStream item = iter.next();
                if (item.isFormField()) continue;
                String contentType = item.getContentType();
                String filename = item.getName();
                stream = item.openStream();
                FileResource fileResource2 = fileResource = this.service.upload(stream, filename, contentType);
                return fileResource2;
            }
        }
        LOGGER.warn("Invalid file resource!");
        return null;
    }
}

