/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springdata.domain.PageConverter;
import de.digitalcollections.commons.springdata.domain.PageWrapper;
import de.digitalcollections.commons.springdata.domain.PageableConverter;
import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiCollectionsClient;
import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.entity.Collection;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.view.BreadcrumbNavigation;
import de.digitalcollections.model.impl.paging.PageRequestImpl;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class CollectionsController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionsController.class);
    private final LanguageSortingHelper languageSortingHelper;
    private final CudamiLocalesClient localeService;
    private final CudamiCollectionsClient service;

    @Autowired
    public CollectionsController(LanguageSortingHelper languageSortingHelper, CudamiClient cudamiClient) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeService = cudamiClient.forLocales();
        this.service = cudamiClient.forCollections();
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "collections";
    }

    @PatchMapping(value={"/api/collections/{uuid}/digitalobjects"})
    public ResponseEntity addDigitalObjects(@PathVariable UUID uuid, @RequestBody List<DigitalObject> digitalObjects) throws HttpException {
        boolean successful = this.service.addDigitalObjects(uuid, digitalObjects);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/collections/new"})
    public String create(Model model, @RequestParam(name="parentType", required=false) String parentType, @RequestParam(name="parentUuid", required=false) String parentUuid) throws HttpException {
        model.addAttribute("activeLanguage", (Object)this.localeService.getDefaultLanguage());
        model.addAttribute("parentType", (Object)parentType);
        model.addAttribute("parentUuid", (Object)parentUuid);
        return "collections/create";
    }

    @GetMapping(value={"/api/collections/new"})
    @ResponseBody
    public Collection create() {
        return this.service.create();
    }

    @GetMapping(value={"/collections/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Collection collection = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, collection.getLabel().getLocales());
        model.addAttribute("activeLanguage", existingLanguages.get(0));
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("uuid", (Object)collection.getUuid());
        return "collections/edit";
    }

    @GetMapping(value={"/api/collections/{uuid}"})
    @ResponseBody
    public Collection get(@PathVariable UUID uuid) throws HttpException {
        return this.service.findOne(uuid);
    }

    @GetMapping(value={"/api/collections/{uuid}/digitalobjects"})
    @ResponseBody
    public PageResponse<DigitalObject> getDigitalObjects(@PathVariable UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize) throws HttpException {
        PageRequestImpl pageRequest = new PageRequestImpl();
        pageRequest.setPageNumber(pageNumber);
        pageRequest.setPageSize(pageSize);
        return this.service.getDigitalObjects(uuid, (PageRequest)pageRequest);
    }

    @GetMapping(value={"/collections"})
    public String list(Model model, @PageableDefault(sort={"lastModified"}, direction=Sort.Direction.DESC, size=25) Pageable pageable) throws HttpException {
        PageRequest pageRequest = PageableConverter.convert((Pageable)pageable);
        PageResponse pageResponse = this.service.findTopCollections(pageRequest);
        Page page = PageConverter.convert((PageResponse)pageResponse, (PageRequest)pageRequest);
        model.addAttribute("page", (Object)new PageWrapper(page, "/collections"));
        return "collections/list";
    }

    @DeleteMapping(value={"/api/collections/{collectionUuid}/digitalobjects/{digitalobjectUuid}"})
    @ResponseBody
    public ResponseEntity removeDigitalObject(@PathVariable UUID collectionUuid, @PathVariable UUID digitalobjectUuid) throws HttpException {
        boolean successful = this.service.removeDigitalObject(collectionUuid, digitalobjectUuid);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/api/collections/new"})
    public ResponseEntity save(@RequestBody Collection collection, @RequestParam(name="parentType", required=false) String parentType, @RequestParam(name="parentUuid", required=false) UUID parentUuid) {
        try {
            Collection collectionDb = null;
            collectionDb = "collection".equals(parentType) ? this.service.saveWithParentCollection(collection, parentUuid) : this.service.save(collection);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)collectionDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save collection: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/collections/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Collection collection) {
        try {
            Collection collectionDb = this.service.update(uuid, collection);
            return ResponseEntity.ok((Object)collectionDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save collection with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/collections/{uuid}"})
    public String view(@PathVariable UUID uuid, @PageableDefault(size=25) Pageable pageable, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Collection collection = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, collection.getLabel().getLocales());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("collection", (Object)collection);
        BreadcrumbNavigation breadcrumbNavigation = this.service.getBreadcrumbNavigation(uuid);
        List breadcrumbs = breadcrumbNavigation.getNavigationItems();
        model.addAttribute("breadcrumbs", (Object)breadcrumbs);
        return "collections/view";
    }
}

