/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity.parts;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.client.CudamiSubtopicsClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.entity.Topic;
import de.digitalcollections.model.api.identifiable.entity.parts.Subtopic;
import de.digitalcollections.model.api.view.BreadcrumbNavigation;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SubtopicsController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubtopicsController.class);
    private final LanguageSortingHelper languageSortingHelper;
    private final CudamiLocalesClient localeService;
    private final CudamiSubtopicsClient service;

    @Autowired
    public SubtopicsController(LanguageSortingHelper languageSortingHelper, CudamiClient cudamiClient) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeService = cudamiClient.forLocales();
        this.service = cudamiClient.forSubtopics();
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "subtopics";
    }

    @GetMapping(value={"/subtopics/new"})
    public String create(Model model, @RequestParam(value="parentType") String parentType, @RequestParam(value="parentUuid") String parentUuid) throws HttpException {
        model.addAttribute("activeLanguage", (Object)this.localeService.getDefaultLanguage());
        model.addAttribute("parentType", (Object)parentType);
        model.addAttribute("parentUuid", (Object)parentUuid);
        return "subtopics/create";
    }

    @GetMapping(value={"/api/subtopics/new"})
    @ResponseBody
    public Subtopic create() {
        return this.service.create();
    }

    @GetMapping(value={"/subtopics/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Subtopic subtopic = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, subtopic.getLabel().getLocales());
        model.addAttribute("activeLanguage", existingLanguages.get(0));
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("uuid", (Object)subtopic.getUuid());
        return "subtopics/edit";
    }

    @GetMapping(value={"/api/subtopics/{uuid}"})
    @ResponseBody
    public Subtopic get(@PathVariable UUID uuid) throws HttpException {
        return this.service.findOne(uuid);
    }

    @PostMapping(value={"/api/subtopics/new"})
    public ResponseEntity save(@RequestBody Subtopic subtopic, @RequestParam(value="parentType") String parentType, @RequestParam(value="parentUuid") UUID parentUuid) {
        try {
            Subtopic subtopicDb = null;
            subtopicDb = parentType.equals("topic") ? this.service.saveWithParentTopic(subtopic, parentUuid) : this.service.saveWithParentSubtopic(subtopic, parentUuid);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)subtopicDb);
        }
        catch (HttpException e) {
            if (parentType.equals("topic")) {
                LOGGER.error("Cannot save top-level subtopic: ", (Throwable)e);
            } else if (parentType.equals("subtopic")) {
                LOGGER.error("Cannot save subtopic: ", (Throwable)e);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/subtopics/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Subtopic subtopic) {
        try {
            Subtopic subtopicDb = this.service.update(uuid, subtopic);
            return ResponseEntity.ok((Object)subtopicDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save subtopic with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/subtopics/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Subtopic subtopic = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, subtopic.getLabel().getLocales());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("subtopic", (Object)subtopic);
        List relatedFileResources = this.service.getFileResources(uuid);
        model.addAttribute("relatedFileResources", (Object)relatedFileResources);
        List relatedEntities = this.service.getEntities(uuid);
        model.addAttribute("relatedEntities", (Object)relatedEntities);
        BreadcrumbNavigation breadcrumbNavigation = this.service.getBreadcrumbNavigation(uuid);
        List breadcrumbs = breadcrumbNavigation.getNavigationItems();
        breadcrumbs.removeIf(n -> n.getUuid() == null);
        model.addAttribute("breadcrumbs", (Object)breadcrumbs);
        Topic topic = this.service.getTopic(uuid);
        model.addAttribute("topic", (Object)topic);
        return "subtopics/view";
    }
}

