/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiCollectionsClient;
import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.Node;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.paging.Order;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.SearchPageRequest;
import de.digitalcollections.model.api.paging.SearchPageResponse;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.api.paging.enums.Direction;
import de.digitalcollections.model.impl.identifiable.entity.CollectionImpl;
import de.digitalcollections.model.impl.paging.OrderImpl;
import de.digitalcollections.model.impl.paging.PageRequestImpl;
import de.digitalcollections.model.impl.paging.SearchPageRequestImpl;
import de.digitalcollections.model.impl.paging.SortingImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class CollectionsController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionsController.class);
    private final LanguageSortingHelper languageSortingHelper;
    private final CudamiLocalesClient localeService;
    private final CudamiCollectionsClient service;

    @Autowired
    public CollectionsController(LanguageSortingHelper languageSortingHelper, CudamiClient cudamiClient) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeService = cudamiClient.forLocales();
        this.service = cudamiClient.forCollections();
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "collections";
    }

    @PostMapping(value={"/api/collections/{uuid}/digitalobjects"})
    public ResponseEntity addDigitalObjects(@PathVariable UUID uuid, @RequestBody List<DigitalObject> digitalObjects) throws HttpException {
        boolean successful = this.service.addDigitalObjects(uuid, digitalObjects);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/api/collections/{collectionUuid}/subcollections/{subcollectionUuid}"})
    public ResponseEntity addSubcollection(@PathVariable UUID collectionUuid, @PathVariable UUID subcollectionUuid) throws HttpException {
        boolean successful = this.service.addSubcollection(collectionUuid, subcollectionUuid);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/api/collections/{collectionUuid}/subcollections"})
    public ResponseEntity addSubcollections(@PathVariable UUID collectionUuid, @RequestBody List<de.digitalcollections.model.api.identifiable.entity.Collection> subcollections) throws HttpException {
        boolean successful = this.service.addSubcollections(collectionUuid, subcollections);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/collections/new", "/subcollections/new"})
    public String create(Model model, @RequestParam(name="parentType", required=false) String parentType, @RequestParam(name="parentUuid", required=false) String parentUuid) throws HttpException {
        model.addAttribute("activeLanguage", (Object)this.localeService.getDefaultLanguage());
        model.addAttribute("parentType", (Object)parentType);
        model.addAttribute("parentUuid", (Object)parentUuid);
        return "collections/create";
    }

    @GetMapping(value={"/api/collections/new"})
    @ResponseBody
    public de.digitalcollections.model.api.identifiable.entity.Collection create() {
        return this.service.create();
    }

    @GetMapping(value={"/collections/{uuid}/edit", "/subcollections/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        de.digitalcollections.model.api.identifiable.entity.Collection collection = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)collection.getLabel().getLocales());
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("uuid", (Object)collection.getUuid());
        return "collections/edit";
    }

    @GetMapping(value={"/api/collections"})
    @ResponseBody
    public PageResponse<CollectionImpl> findAllTop(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize) throws HttpException {
        PageRequestImpl pageRequest = new PageRequestImpl(pageNumber, pageSize);
        return this.service.findTopCollections((PageRequest)pageRequest);
    }

    @GetMapping(value={"/api/collections/identifier/{namespace}:{id}", "/api/subcollections/identifier/{namespace}:{id}"})
    @ResponseBody
    public de.digitalcollections.model.api.identifiable.entity.Collection findOneByIdentifier(@PathVariable String namespace, @PathVariable String id) throws HttpException {
        return this.service.findOneByIdentifier(namespace, id);
    }

    @GetMapping(value={"/api/collections/{uuid}"})
    @ResponseBody
    public de.digitalcollections.model.api.identifiable.entity.Collection get(@PathVariable UUID uuid) throws HttpException {
        return this.service.findOne(uuid);
    }

    @GetMapping(value={"/api/collections/{uuid}/digitalobjects"})
    @ResponseBody
    public PageResponse<DigitalObject> getDigitalObjects(@PathVariable UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize) throws HttpException {
        return this.service.getDigitalObjects(uuid, (PageRequest)new PageRequestImpl(pageNumber, pageSize));
    }

    @GetMapping(value={"/api/collections/{uuid}/subcollections"})
    @ResponseBody
    public PageResponse<de.digitalcollections.model.api.identifiable.entity.Collection> getSubcollections(@PathVariable UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize) throws HttpException {
        return this.service.getSubcollections(uuid, (PageRequest)new PageRequestImpl(pageNumber, pageSize));
    }

    @GetMapping(value={"/collections"})
    public String list(Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        model.addAttribute("existingLanguages", (Object)this.languageSortingHelper.sortLanguages(displayLocale, (Collection)this.service.getTopCollectionsLanguages()));
        return "collections/list";
    }

    @DeleteMapping(value={"/api/collections/{collectionUuid}/digitalobjects/{digitalobjectUuid}"})
    @ResponseBody
    public ResponseEntity removeDigitalObject(@PathVariable UUID collectionUuid, @PathVariable UUID digitalobjectUuid) throws HttpException {
        boolean successful = this.service.removeDigitalObject(collectionUuid, digitalobjectUuid);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/api/collections/{collectionUuid}/subcollections/{subcollectionUuid}"})
    public ResponseEntity removeSubcollection(@PathVariable UUID collectionUuid, @PathVariable UUID subcollectionUuid) throws HttpException {
        boolean successful = this.service.removeSubcollection(collectionUuid, subcollectionUuid);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/api/collections/new"})
    public ResponseEntity save(@RequestBody de.digitalcollections.model.api.identifiable.entity.Collection collection, @RequestParam(name="parentType", required=false) String parentType, @RequestParam(name="parentUuid", required=false) UUID parentUuid) {
        try {
            de.digitalcollections.model.api.identifiable.entity.Collection collectionDb = null;
            collectionDb = "collection".equals(parentType) ? this.service.saveWithParentCollection(collection, parentUuid) : this.service.save(collection);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)collectionDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save collection: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/api/collections/search", "/api/subcollections/search"})
    @ResponseBody
    public SearchPageResponse<CollectionImpl> search(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortField", required=false, defaultValue="lastModified") String sortField, @RequestParam(name="sortDirection", required=false, defaultValue="DESC") Direction sortDirection, @RequestParam(name="searchTerm", required=false) String searchTerm) throws HttpException {
        OrderImpl order = new OrderImpl(sortDirection, sortField);
        SortingImpl sorting = new SortingImpl(new Order[]{order});
        SearchPageRequestImpl pageRequest = new SearchPageRequestImpl(searchTerm, pageNumber, pageSize, (Sorting)sorting);
        return this.service.find((SearchPageRequest)pageRequest);
    }

    @PutMapping(value={"/api/collections/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody de.digitalcollections.model.api.identifiable.entity.Collection collection) {
        try {
            de.digitalcollections.model.api.identifiable.entity.Collection collectionDb = this.service.update(uuid, collection);
            return ResponseEntity.ok((Object)collectionDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save collection with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/collections/{uuid}", "/subcollections/{uuid}"})
    public String view(@PathVariable UUID uuid, @PageableDefault(size=25) Pageable pageable, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        de.digitalcollections.model.api.identifiable.entity.Collection collection = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)collection.getLabel().getLocales());
        List existingSubcollectionLanguages = collection.getChildren().stream().flatMap(child -> child.getLabel().getLocales().stream()).collect(Collectors.toList());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("existingSubcollectionLanguages", (Object)this.languageSortingHelper.sortLanguages(displayLocale, existingSubcollectionLanguages));
        model.addAttribute("collection", (Object)collection);
        List parents = this.service.getParents(uuid);
        model.addAttribute("parents", (Object)parents);
        ArrayList breadcrumbs = new ArrayList();
        this.addParentNodeToBreadcrumb((Node)collection, breadcrumbs);
        Collections.reverse(breadcrumbs);
        model.addAttribute("breadcrumbs", breadcrumbs);
        return "collections/view";
    }

    private void addParentNodeToBreadcrumb(Node currentNode, List<Node> breadcrumbs) throws HttpException {
        de.digitalcollections.model.api.identifiable.entity.Collection parent = this.service.getParent(currentNode.getUuid());
        if (parent != null && parent.getUuid() != null) {
            breadcrumbs.add((Node)parent);
            this.addParentNodeToBreadcrumb((Node)parent, breadcrumbs);
        }
    }
}

