/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.listener;

import java.util.EnumSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.annotation.WebListener;

@WebListener
public class ServletContextListenerImpl
implements ServletContextListener {
    public void contextDestroyed(ServletContextEvent sce) {
    }

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        EnumSet<SessionTrackingMode> modes = EnumSet.noneOf(SessionTrackingMode.class);
        modes.add(SessionTrackingMode.COOKIE);
        servletContext.setSessionTrackingModes(modes);
        SessionCookieConfig sessionCookieConfig = servletContext.getSessionCookieConfig();
        sessionCookieConfig.setHttpOnly(true);
        String activeProfile = System.getProperty("spring.profiles.active", "PROD");
        if (activeProfile != null && "PROD".equals(activeProfile)) {
            sessionCookieConfig.setSecure(true);
        }
    }
}

