/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity.agent;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.client.entity.agent.CudamiPersonsClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.entity.agent.Person;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.impl.identifiable.entity.agent.PersonImpl;
import de.digitalcollections.model.impl.paging.OrderImpl;
import de.digitalcollections.model.impl.paging.PageRequestImpl;
import de.digitalcollections.model.impl.paging.SortingImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PersonsController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonsController.class);
    private final LanguageSortingHelper languageSortingHelper;
    private final CudamiLocalesClient localeService;
    private final CudamiPersonsClient service;

    @Autowired
    public PersonsController(LanguageSortingHelper languageSortingHelper, CudamiClient cudamiClient) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeService = cudamiClient.forLocales();
        this.service = cudamiClient.forPersons();
    }

    @GetMapping(value={"/persons/new"})
    public String create(Model model) throws HttpException {
        model.addAttribute("activeLanguage", (Object)this.localeService.getDefaultLanguage());
        return "persons/create";
    }

    @GetMapping(value={"/api/persons/new"})
    @ResponseBody
    public Person create() {
        return this.service.create();
    }

    @GetMapping(value={"/persons/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Person person = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)person.getLabel().getLocales());
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("uuid", (Object)person.getUuid());
        return "persons/edit";
    }

    @GetMapping(value={"/api/persons"})
    @ResponseBody
    public PageResponse<PersonImpl> findAll(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize) throws HttpException {
        ArrayList<OrderImpl> orders = new ArrayList<OrderImpl>();
        OrderImpl labelOrder = new OrderImpl("label");
        labelOrder.setSubProperty(this.localeService.getDefaultLanguage().getLanguage());
        orders.addAll(Arrays.asList(labelOrder));
        SortingImpl sorting = new SortingImpl(orders);
        PageRequestImpl pageRequest = new PageRequestImpl(pageNumber, pageSize, (Sorting)sorting);
        return this.service.find((PageRequest)pageRequest);
    }

    @GetMapping(value={"/api/persons/{uuid}"})
    @ResponseBody
    public Person get(@PathVariable UUID uuid) throws HttpException {
        return this.service.findOne(uuid);
    }

    @GetMapping(value={"/persons"})
    public String list() {
        return "persons/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "persons";
    }

    @PostMapping(value={"/api/persons/new"})
    public ResponseEntity save(@RequestBody Person person) {
        try {
            Person personDb = this.service.save(person);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)personDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save person: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/persons/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Person person) {
        try {
            Person personDb = this.service.update(uuid, person);
            return ResponseEntity.ok((Object)personDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save person with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/persons/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Person person = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)person.getLabel().getLocales());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("person", (Object)person);
        return "persons/view";
    }
}

