/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiDigitalObjectsClient;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.identifiable.entity.Project;
import de.digitalcollections.model.paging.Direction;
import de.digitalcollections.model.paging.Order;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import de.digitalcollections.model.paging.Sorting;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DigitalObjectsController
extends AbstractController {
    private final LanguageSortingHelper languageSortingHelper;
    private final CudamiDigitalObjectsClient service;

    public DigitalObjectsController(LanguageSortingHelper languageSortingHelper, CudamiClient client) {
        this.languageSortingHelper = languageSortingHelper;
        this.service = client.forDigitalObjects();
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "digitalobjects";
    }

    @GetMapping(value={"/api/digitalobjects/identifier/{namespace}:{id}"})
    @ResponseBody
    public DigitalObject findOneByIdentifier(@PathVariable String namespace, @PathVariable String id) throws HttpException {
        return this.service.findOneByIdentifier(namespace, id);
    }

    @GetMapping(value={"/api/digitalobjects/{uuid}/collections"}, produces={"application/json"})
    @ResponseBody
    public PageResponse<de.digitalcollections.model.identifiable.entity.Collection> getAssociatedCollections(@PathVariable UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize) throws HttpException {
        return this.service.getCollections(uuid, new PageRequest(pageNumber, pageSize));
    }

    @GetMapping(value={"/api/digitalobjects/{uuid}/projects"}, produces={"application/json"})
    @ResponseBody
    public PageResponse<Project> getAssociatedProjects(@PathVariable UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize) throws HttpException {
        return this.service.getProjects(uuid, new PageRequest(pageNumber, pageSize));
    }

    @GetMapping(value={"/digitalobjects"})
    public String list(Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        model.addAttribute("existingLanguages", (Object)this.languageSortingHelper.sortLanguages(displayLocale, (Collection)this.service.getLanguages()));
        return "digitalobjects/list";
    }

    @GetMapping(value={"/api/digitalobjects"})
    @ResponseBody
    public PageResponse<DigitalObject> findAll(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm) throws HttpException {
        SearchPageRequest searchPageRequest = new SearchPageRequest(searchTerm, pageNumber, pageSize);
        return this.service.find(searchPageRequest);
    }

    @GetMapping(value={"/api/digitalobjects/search"})
    @ResponseBody
    public SearchPageResponse<DigitalObject> search(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortField", required=false) String sortField, @RequestParam(name="sortDirection", required=false) Direction sortDirection, @RequestParam(name="searchTerm", required=false) String searchTerm) throws HttpException {
        Sorting sorting = null;
        if (sortField != null && sortDirection != null) {
            Order order = new Order(sortDirection, sortField);
            sorting = new Sorting(new Order[]{order});
        }
        SearchPageRequest pageRequest = new SearchPageRequest(searchTerm, pageNumber, pageSize, sorting);
        return this.service.find(pageRequest);
    }

    @GetMapping(value={"/digitalobjects/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) throws HttpException {
        DigitalObject digitalObject = this.service.findOne(uuid);
        model.addAttribute("digitalObject", (Object)digitalObject);
        List existingCollectionLanguages = this.service.getLanguagesOfCollections(uuid);
        List existingProjectLanguages = this.service.getLanguagesOfProjects(uuid);
        model.addAttribute("existingCollectionLanguages", (Object)existingCollectionLanguages).addAttribute("existingProjectLanguages", (Object)existingProjectLanguages);
        return "digitalobjects/view";
    }
}

