/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.security;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.admin.business.api.service.security.UserService;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.security.Role;
import de.digitalcollections.model.security.User;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@SessionAttributes(value={"user"})
public class UserController
extends AbstractController {
    private final MessageSource messageSource;
    private final UserService service;

    public UserController(MessageSource messageSource, UserService service) {
        this.messageSource = messageSource;
        this.service = service;
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "users";
    }

    @ModelAttribute(value="allRoles")
    protected List<Role> populateAllRoles() {
        return Arrays.asList(Role.values());
    }

    @InitBinder(value={"user"})
    protected void initBinder(WebDataBinder binder) {
    }

    @GetMapping(value={"/users/new"})
    public String create(Model model) {
        model.addAttribute("user", (Object)this.service.create());
        return "users/create";
    }

    @PostMapping(value={"/users/new"})
    public String create(@RequestParam(value="pwd1") String password1, @RequestParam(value="pwd2") String password2, @ModelAttribute(name="user") @Valid User user, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) throws ServiceException {
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "users/create";
        }
        User userDb = this.service.create(user, password1, password2, (Errors)results);
        if (results.hasErrors()) {
            return "users/create";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.created_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/users/" + userDb.getUuid().toString();
    }

    @GetMapping(value={"/users/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, Model model) throws ServiceException {
        model.addAttribute("user", (Object)this.service.findOne(uuid));
        return "users/edit";
    }

    @PostMapping(value={"/users/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="pwd1", required=false) String password1, @RequestParam(name="pwd2", required=false) String password2, @ModelAttribute(name="user") @Valid User user, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) throws ServiceException {
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "users/edit";
        }
        this.service.update(user, password1, password2, (Errors)results);
        if (results.hasErrors()) {
            return "users/edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changes_saved_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/users/" + uuid;
    }

    @GetMapping(value={"/api/users"})
    @ResponseBody
    public PageResponse<User> findAll(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize) throws ServiceException {
        PageRequest pageRequest = new PageRequest(pageNumber, pageSize);
        return this.service.find(pageRequest);
    }

    @GetMapping(value={"/users"})
    public String list() {
        return "users/list";
    }

    @PatchMapping(value={"/api/users/{uuid}"})
    public ResponseEntity setStatus(@PathVariable(value="uuid") UUID uuid, @RequestBody User user) {
        boolean successful = this.service.setStatus(uuid, user.isEnabled());
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @GetMapping(value={"/users/updatePassword"})
    public String updatePassword(Model model) throws ServiceException {
        User currentUser = this.service.findByEmail(SecurityContextHolder.getContext().getAuthentication().getName());
        model.addAttribute("user", (Object)currentUser);
        return "users/edit-password";
    }

    @PostMapping(value={"/users/updatePassword"})
    public String updatePassword(@RequestParam(value="pwd1") String password1, @RequestParam(value="pwd2") String password2, @ModelAttribute(name="user") @Valid User user, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) throws ServiceException {
        this.verifyBinding(results);
        String errorMessage = this.messageSource.getMessage("error.password_change_failed", null, LocaleContextHolder.getLocale());
        if (results.hasErrors()) {
            model.addAttribute("error_message", (Object)errorMessage);
            return "users/edit-password";
        }
        this.service.update(user, password1, password2, (Errors)results);
        if (results.hasErrors()) {
            model.addAttribute("error_message", (Object)errorMessage);
            return "users/edit-password";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changed_password_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/";
    }

    @GetMapping(value={"/users/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) throws ServiceException {
        model.addAttribute("user", (Object)this.service.findOne(uuid));
        return "users/view";
    }
}

