/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity.agent;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.cudami.client.identifiable.entity.agent.CudamiCorporateBodiesClient;
import de.digitalcollections.model.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class CorporateBodiesController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CorporateBodiesController.class);
    private final LanguageSortingHelper languageSortingHelper;
    private final CudamiLocalesClient localeService;
    private final CudamiCorporateBodiesClient service;

    public CorporateBodiesController(LanguageSortingHelper languageSortingHelper, CudamiClient client) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeService = client.forLocales();
        this.service = client.forCorporateBodies();
    }

    @GetMapping(value={"/corporatebodies/new"})
    public String create(Model model) throws HttpException {
        model.addAttribute("activeLanguage", (Object)this.localeService.getDefaultLanguage());
        return "corporatebodies/create";
    }

    @GetMapping(value={"/api/corporatebodies/new"})
    @ResponseBody
    public CorporateBody create() {
        return this.service.create();
    }

    @GetMapping(value={"/corporatebodies/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        CorporateBody corporateBody = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)corporateBody.getLabel().getLocales());
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("uuid", (Object)corporateBody.getUuid());
        return "corporatebodies/edit";
    }

    @GetMapping(value={"/api/corporatebodies"})
    @ResponseBody
    public PageResponse<CorporateBody> findAll(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm) throws HttpException {
        SearchPageRequest searchPageRequest = new SearchPageRequest(searchTerm, pageNumber, pageSize);
        return this.service.find(searchPageRequest);
    }

    @GetMapping(value={"/api/corporatebodies/{uuid}"})
    @ResponseBody
    public CorporateBody get(@PathVariable UUID uuid) throws HttpException {
        return this.service.findOne(uuid);
    }

    @GetMapping(value={"/corporatebodies"})
    public String list(Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        model.addAttribute("existingLanguages", (Object)this.languageSortingHelper.sortLanguages(displayLocale, (Collection)this.service.getLanguages()));
        return "corporatebodies/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "corporatebodies";
    }

    @PostMapping(value={"/api/corporatebodies"})
    public ResponseEntity save(@RequestBody CorporateBody corporateBody) {
        try {
            CorporateBody corporateBodyDb = this.service.save(corporateBody);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)corporateBodyDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save corporate body: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/corporatebodies/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody CorporateBody corporateBody) {
        try {
            CorporateBody corporateBodyDb = this.service.update(uuid, corporateBody);
            return ResponseEntity.ok((Object)corporateBodyDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save corporate body with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/corporatebodies/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        CorporateBody corporateBody = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)corporateBody.getLabel().getLocales());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("corporateBody", (Object)corporateBody);
        return "corporatebodies/view";
    }
}

