/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiCollectionsClient;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.paging.Direction;
import de.digitalcollections.model.paging.Order;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import de.digitalcollections.model.paging.Sorting;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class CollectionsController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionsController.class);
    private final LanguageSortingHelper languageSortingHelper;
    private final CudamiLocalesClient localeService;
    private final CudamiCollectionsClient service;

    public CollectionsController(LanguageSortingHelper languageSortingHelper, CudamiClient client) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeService = client.forLocales();
        this.service = client.forCollections();
    }

    @PostMapping(value={"/api/collections/{uuid}/digitalobjects"})
    public ResponseEntity addDigitalObjects(@PathVariable UUID uuid, @RequestBody List<DigitalObject> digitalObjects) throws HttpException {
        boolean successful = this.service.addDigitalObjects(uuid, digitalObjects);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/api/collections/{collectionUuid}/subcollections/{subcollectionUuid}"})
    public ResponseEntity addSubcollection(@PathVariable UUID collectionUuid, @PathVariable UUID subcollectionUuid) throws HttpException {
        boolean successful = this.service.addSubcollection(collectionUuid, subcollectionUuid);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/api/collections/{collectionUuid}/subcollections"})
    public ResponseEntity addSubcollections(@PathVariable UUID collectionUuid, @RequestBody List<de.digitalcollections.model.identifiable.entity.Collection> subcollections) throws HttpException {
        boolean successful = this.service.addSubcollections(collectionUuid, subcollections);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/collections/new", "/subcollections/new"})
    public String create(Model model, @RequestParam(name="parentType", required=false) String parentType, @RequestParam(name="parentUuid", required=false) String parentUuid) throws HttpException {
        model.addAttribute("activeLanguage", (Object)this.localeService.getDefaultLanguage());
        model.addAttribute("parentType", (Object)parentType);
        model.addAttribute("parentUuid", (Object)parentUuid);
        return "collections/create";
    }

    @GetMapping(value={"/api/collections/new"})
    @ResponseBody
    public de.digitalcollections.model.identifiable.entity.Collection create() {
        return this.service.create();
    }

    @GetMapping(value={"/collections/{uuid}/edit", "/subcollections/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        de.digitalcollections.model.identifiable.entity.Collection collection = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)collection.getLabel().getLocales());
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("uuid", (Object)collection.getUuid());
        return "collections/edit";
    }

    @GetMapping(value={"/api/collections"})
    @ResponseBody
    public SearchPageResponse<de.digitalcollections.model.identifiable.entity.Collection> findAllTop(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm) throws HttpException {
        SearchPageRequest searchPageRequest = new SearchPageRequest(searchTerm, pageNumber, pageSize);
        return this.service.findTopCollections(searchPageRequest);
    }

    @GetMapping(value={"/api/collections/{uuid}/digitalobjects"})
    @ResponseBody
    public PageResponse<DigitalObject> findDigitalObjects(@PathVariable UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm) throws HttpException {
        SearchPageRequest searchPageRequest = new SearchPageRequest(searchTerm, pageNumber, pageSize);
        return this.service.getDigitalObjects(uuid, searchPageRequest);
    }

    @GetMapping(value={"/api/collections/identifier/{namespace}:{id}", "/api/subcollections/identifier/{namespace}:{id}"})
    @ResponseBody
    public de.digitalcollections.model.identifiable.entity.Collection findOneByIdentifier(@PathVariable String namespace, @PathVariable String id) throws HttpException {
        return this.service.findOneByIdentifier(namespace, id);
    }

    @GetMapping(value={"/api/collections/{uuid}/subcollections"})
    @ResponseBody
    public PageResponse<de.digitalcollections.model.identifiable.entity.Collection> findSubcollections(@PathVariable UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm) throws HttpException {
        SearchPageRequest searchPageRequest = new SearchPageRequest(searchTerm, pageNumber, pageSize);
        return this.service.findSubcollections(uuid, searchPageRequest);
    }

    @GetMapping(value={"/api/collections/{uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}}", "/api/subcollections/{uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}}"})
    @ResponseBody
    public de.digitalcollections.model.identifiable.entity.Collection get(@PathVariable UUID uuid) throws HttpException {
        return this.service.findOne(uuid);
    }

    @GetMapping(value={"/api/collections/{refId:[0-9]+}", "/api/subcollections/{refId:[0-9]+}"})
    @ResponseBody
    public de.digitalcollections.model.identifiable.entity.Collection getByRefId(@PathVariable long refId) throws HttpException {
        return this.service.findOneByRefId(refId);
    }

    @GetMapping(value={"/collections"})
    public String list(Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        model.addAttribute("existingLanguages", (Object)this.languageSortingHelper.sortLanguages(displayLocale, (Collection)this.service.getTopCollectionsLanguages()));
        return "collections/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "collections";
    }

    @DeleteMapping(value={"/api/collections/{collectionUuid}/digitalobjects/{digitalobjectUuid}"})
    @ResponseBody
    public ResponseEntity removeDigitalObject(@PathVariable UUID collectionUuid, @PathVariable UUID digitalobjectUuid) throws HttpException {
        boolean successful = this.service.removeDigitalObject(collectionUuid, digitalobjectUuid);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/api/collections/{collectionUuid}/subcollections/{subcollectionUuid}"})
    public ResponseEntity removeSubcollection(@PathVariable UUID collectionUuid, @PathVariable UUID subcollectionUuid) throws HttpException {
        boolean successful = this.service.removeSubcollection(collectionUuid, subcollectionUuid);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/api/collections"})
    public ResponseEntity save(@RequestBody de.digitalcollections.model.identifiable.entity.Collection collection, @RequestParam(name="parentType", required=false) String parentType, @RequestParam(name="parentUuid", required=false) UUID parentUuid) {
        try {
            de.digitalcollections.model.identifiable.entity.Collection collectionDb = null;
            collectionDb = "collection".equals(parentType) ? this.service.saveWithParentCollection(collection, parentUuid) : this.service.save(collection);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)collectionDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save collection: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/api/collections/search", "/api/subcollections/search"})
    @ResponseBody
    public SearchPageResponse<de.digitalcollections.model.identifiable.entity.Collection> search(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortField", required=false) String sortField, @RequestParam(name="sortDirection", required=false) Direction sortDirection, @RequestParam(name="searchTerm", required=false) String searchTerm) throws HttpException {
        Sorting sorting = null;
        if (sortField != null && sortDirection != null) {
            Order order = new Order(sortDirection, sortField);
            sorting = new Sorting(new Order[]{order});
        }
        SearchPageRequest pageRequest = new SearchPageRequest(searchTerm, pageNumber, pageSize, sorting);
        return this.service.find(pageRequest);
    }

    @PutMapping(value={"/api/collections/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody de.digitalcollections.model.identifiable.entity.Collection collection) {
        try {
            de.digitalcollections.model.identifiable.entity.Collection collectionDb = this.service.update(uuid, collection);
            return ResponseEntity.ok((Object)collectionDb);
        }
        catch (HttpException e) {
            LOGGER.error("Cannot save collection with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/collections/{uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}}", "/subcollections/{uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}}"})
    public String view(@PathVariable UUID uuid, Model model) throws HttpException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        de.digitalcollections.model.identifiable.entity.Collection collection = this.service.findOne(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)collection.getLabel().getLocales());
        List existingSubcollectionLanguages = collection.getChildren().stream().flatMap(child -> child.getLabel().getLocales().stream()).collect(Collectors.toList());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("existingSubcollectionLanguages", (Object)this.languageSortingHelper.sortLanguages(displayLocale, existingSubcollectionLanguages));
        model.addAttribute("collection", (Object)collection);
        List parents = this.service.getParents(uuid);
        model.addAttribute("parents", (Object)parents);
        BreadcrumbNavigation breadcrumbNavigation = this.service.getBreadcrumbNavigation(uuid);
        List breadcrumbs = breadcrumbNavigation.getNavigationItems();
        model.addAttribute("breadcrumbs", (Object)breadcrumbs);
        return "collections/view";
    }

    @GetMapping(value={"/collections/{refId:[0-9]+}", "/subcollections/{refId:[0-9]+}"})
    public String viewByRefId(@PathVariable long refId, Model model) throws HttpException {
        de.digitalcollections.model.identifiable.entity.Collection collection = this.service.findOneByRefId(refId);
        return this.view(collection.getUuid(), model);
    }
}

