/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiTopicsClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.Topic;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class TopicsController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopicsController.class);
    private final LanguageSortingHelper languageSortingHelper;
    private final CudamiLocalesClient localeService;
    private final CudamiTopicsClient service;

    public TopicsController(LanguageSortingHelper languageSortingHelper, CudamiClient client) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeService = client.forLocales();
        this.service = client.forTopics();
    }

    @GetMapping(value={"/subtopics/new", "/topics/new"})
    public String create(Model model, @RequestParam(name="parentType", required=false) String parentType, @RequestParam(name="parentUuid", required=false) UUID parentUuid) throws TechnicalException {
        model.addAttribute("activeLanguage", (Object)this.localeService.getDefaultLanguage());
        model.addAttribute("parentType", (Object)parentType);
        model.addAttribute("parentUuid", (Object)parentUuid);
        return "topics/create";
    }

    @GetMapping(value={"/api/topics/new"})
    @ResponseBody
    public Topic create() throws TechnicalException {
        return (Topic)this.service.create();
    }

    @GetMapping(value={"/subtopics/{uuid}/edit", "/topics/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws TechnicalException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Topic topic = (Topic)this.service.getByUuid(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)topic.getLabel().getLocales());
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("uuid", (Object)topic.getUuid());
        return "topics/edit";
    }

    @GetMapping(value={"/api/topics"})
    @ResponseBody
    public PageResponse<Topic> findTop(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm, @RequestParam(name="sortBy", required=false) List<Order> sortBy) throws TechnicalException {
        PageRequest pageRequest = new PageRequest(searchTerm, pageNumber, pageSize);
        if (sortBy != null) {
            Sorting sorting = new Sorting(sortBy);
            pageRequest.setSorting(sorting);
        }
        return this.service.findTopTopics(pageRequest);
    }

    @GetMapping(value={"/api/topics/{uuid}/subtopics"})
    @ResponseBody
    public PageResponse<Topic> findSubtopic(@PathVariable UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm) throws TechnicalException {
        PageRequest pageRequest = new PageRequest(searchTerm, pageNumber, pageSize);
        return this.service.findSubtopics(uuid, pageRequest);
    }

    @GetMapping(value={"/api/topics/{uuid}/entities"})
    @ResponseBody
    public PageResponse<Entity> getAttachedEntites(@PathVariable UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize) throws TechnicalException {
        return this.service.findEntities(uuid, new PageRequest(pageNumber, pageSize));
    }

    @GetMapping(value={"/api/topics/{uuid}"})
    @ResponseBody
    public Topic getByUuid(@PathVariable UUID uuid) throws TechnicalException {
        return (Topic)this.service.getByUuid(uuid);
    }

    @GetMapping(value={"/api/topics/{uuid}/fileresources"})
    @ResponseBody
    public PageResponse<FileResource> getRelatedFileResources(@PathVariable UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize) throws TechnicalException {
        return this.service.findFileResources(uuid, new PageRequest(pageNumber, pageSize));
    }

    @GetMapping(value={"/topics"})
    public String list(Model model) throws TechnicalException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        model.addAttribute("existingLanguages", (Object)this.languageSortingHelper.sortLanguages(displayLocale, (Collection)this.service.getTopTopicsLanguages()));
        return "topics/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "topics";
    }

    @PostMapping(value={"/api/topics"})
    public ResponseEntity save(@RequestBody Topic topic, @RequestParam(name="parentUuid", required=false) UUID parentUuid) {
        try {
            Topic topicDb = null;
            topicDb = parentUuid == null ? (Topic)this.service.save((UniqueObject)topic) : this.service.saveWithParentTopic(topic, parentUuid);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)topicDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save topic: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/topics/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Topic topic) {
        try {
            Topic topicDb = (Topic)this.service.update(uuid, (UniqueObject)topic);
            return ResponseEntity.ok((Object)topicDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save topic with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/subtopics/{uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}}", "/topics/{uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}}"})
    public String view(@PathVariable UUID uuid, Model model) throws TechnicalException, ResourceNotFoundException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Topic topic = (Topic)this.service.getByUuid(uuid);
        if (topic == null) {
            throw new ResourceNotFoundException();
        }
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)topic.getLabel().getLocales());
        List existingSubtopicLanguages = topic.getChildren().stream().flatMap(child -> child.getLabel().getLocales().stream()).collect(Collectors.toList());
        List existingEntityLanguages = this.service.getLanguagesOfEntities(uuid);
        List existingFileResourceLanguages = this.service.getLanguagesOfFileResources(uuid);
        model.addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("existingSubtopicLanguages", (Object)this.languageSortingHelper.sortLanguages(displayLocale, existingSubtopicLanguages)).addAttribute("topic", (Object)topic).addAttribute("existingEntityLanguages", (Object)this.languageSortingHelper.sortLanguages(displayLocale, (Collection)existingEntityLanguages)).addAttribute("existingFileResourceLanguages", (Object)this.languageSortingHelper.sortLanguages(displayLocale, (Collection)existingFileResourceLanguages));
        BreadcrumbNavigation breadcrumbNavigation = this.service.getBreadcrumbNavigation(uuid);
        List breadcrumbs = breadcrumbNavigation.getNavigationItems();
        model.addAttribute("breadcrumbs", (Object)breadcrumbs);
        return "topics/view";
    }

    @GetMapping(value={"/subtopics/{refId:[0-9]+}", "/topics/{refId:[0-9]+}"})
    public String viewByRefId(@PathVariable long refId, Model model) throws TechnicalException, ResourceNotFoundException {
        Topic topic = (Topic)this.service.getByRefId(refId);
        if (topic == null) {
            throw new ResourceNotFoundException();
        }
        return this.view(topic.getUuid(), model);
    }
}

