/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.business.impl.service.security;

import de.digitalcollections.cudami.admin.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.admin.business.api.service.security.UserService;
import de.digitalcollections.cudami.admin.business.impl.validator.PasswordsValidatorParams;
import de.digitalcollections.cudami.admin.business.impl.validator.UniqueUsernameValidator;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.security.CudamiUsersClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.security.Role;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Service
public class UserServiceImpl
implements UserService<de.digitalcollections.model.security.User>,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserServiceImpl.class);
    private final CudamiUsersClient client;
    private final MessageSource messageSource;
    private final Validator passwordsValidator;
    private Validator uniqueUsernameValidator;

    public UserServiceImpl(@Qualifier(value="passwordsValidator") Validator passwordsValidator, CudamiClient client, MessageSource messageSource) {
        this.passwordsValidator = passwordsValidator;
        this.client = client.forUsers();
        this.messageSource = messageSource;
    }

    public void afterPropertiesSet() {
        this.uniqueUsernameValidator = new UniqueUsernameValidator(this.messageSource, (UserService)this);
    }

    private User buildUserForAuthentication(de.digitalcollections.model.security.User user, List<? extends GrantedAuthority> authorities) {
        return new User(user.getEmail(), user.getPasswordHash(), user.isEnabled(), true, true, true, authorities);
    }

    public long count() throws ServiceException {
        try {
            return this.client.count();
        }
        catch (TechnicalException ex) {
            throw new ServiceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public de.digitalcollections.model.security.User create() throws ServiceException {
        try {
            return (de.digitalcollections.model.security.User)this.client.create();
        }
        catch (TechnicalException e) {
            throw new ServiceException("Cannot create a user: " + e, (Throwable)e);
        }
    }

    public de.digitalcollections.model.security.User create(de.digitalcollections.model.security.User user, String password1, String password2, Errors results) throws ServiceException {
        this.uniqueUsernameValidator.validate((Object)user, results);
        if (!results.hasErrors()) {
            return this.save(password1, password2, user, results, false);
        }
        return null;
    }

    public de.digitalcollections.model.security.User createAdminUser() throws ServiceException {
        de.digitalcollections.model.security.User user = this.create();
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.add(Role.ADMIN);
        user.setRoles(roles);
        return user;
    }

    public boolean doesActiveAdminUserExist() throws ServiceException {
        try {
            List findActiveAdminUsers = this.client.getActiveAdminUsers();
            return findActiveAdminUsers != null && !findActiveAdminUsers.isEmpty();
        }
        catch (TechnicalException ex) {
            throw new ServiceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public PageResponse<de.digitalcollections.model.security.User> find(PageRequest pageRequest) throws ServiceException {
        try {
            return this.client.find(pageRequest);
        }
        catch (TechnicalException ex) {
            throw new ServiceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public List<de.digitalcollections.model.security.User> findAll() throws ServiceException {
        try {
            return this.client.getAll();
        }
        catch (TechnicalException ex) {
            throw new ServiceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public de.digitalcollections.model.security.User getByEmail(String email) throws ServiceException {
        try {
            return this.client.getByEmail(email);
        }
        catch (TechnicalException ex) {
            throw new ServiceException(ex.getMessage(), (Throwable)ex);
        }
    }

    public de.digitalcollections.model.security.User getByUuid(UUID uuid) throws ServiceException {
        try {
            return (de.digitalcollections.model.security.User)this.client.getByUuid(uuid);
        }
        catch (TechnicalException ex) {
            throw new ServiceException(ex.getMessage(), (Throwable)ex);
        }
    }

    private de.digitalcollections.model.security.User save(String password1, String password2, de.digitalcollections.model.security.User user, Errors results, boolean isUpdate) throws ServiceException {
        PasswordsValidatorParams passwordsValidatorParams = new PasswordsValidatorParams(password1, password2, user.getPasswordHash());
        String password = passwordsValidatorParams.getPassword1();
        if (StringUtils.hasText((String)password)) {
            this.passwordsValidator.validate((Object)passwordsValidatorParams, results);
        }
        if (!results.hasErrors()) {
            if (StringUtils.hasText((String)password)) {
                BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
                String passwordHash = passwordEncoder.encode((CharSequence)password);
                user.setPasswordHash(passwordHash);
            }
            try {
                user = isUpdate ? (de.digitalcollections.model.security.User)this.client.update(user.getUuid(), (UniqueObject)user) : (de.digitalcollections.model.security.User)this.client.save((UniqueObject)user);
            }
            catch (TechnicalException ex) {
                throw new ServiceException(ex.getMessage(), (Throwable)ex);
            }
        }
        return user;
    }

    public boolean setStatus(UUID uuid, boolean enabled) {
        try {
            de.digitalcollections.model.security.User user = (de.digitalcollections.model.security.User)this.client.getByUuid(uuid);
            user.setEnabled(enabled);
            this.client.update(user.getUuid(), (UniqueObject)user);
            return true;
        }
        catch (TechnicalException ex) {
            return false;
        }
    }

    public de.digitalcollections.model.security.User update(de.digitalcollections.model.security.User user, String password1, String password2, Errors results) throws ServiceException {
        return this.save(password1, password2, user, results, true);
    }
}

