/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiDigitalObjectsClient;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.identifiable.entity.Project;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DigitalObjectsController
extends AbstractController {
    private final LanguageSortingHelper languageSortingHelper;
    private final CudamiLocalesClient localeService;
    private final CudamiDigitalObjectsClient service;

    public DigitalObjectsController(LanguageSortingHelper languageSortingHelper, CudamiClient client) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeService = client.forLocales();
        this.service = client.forDigitalObjects();
    }

    @GetMapping(value={"/api/digitalobjects", "/api/digitalobjects/search"})
    @ResponseBody
    public PageResponse<DigitalObject> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm, @RequestParam(name="sortBy", required=false) List<Order> sortBy) throws TechnicalException {
        PageRequest pageRequest = new PageRequest(searchTerm, pageNumber, pageSize);
        if (sortBy != null) {
            Sorting sorting = new Sorting(sortBy);
            pageRequest.setSorting(sorting);
        }
        return this.service.find(pageRequest);
    }

    @GetMapping(value={"/api/digitalobjects/{uuid}/collections"}, produces={"application/json"})
    @ResponseBody
    public PageResponse<de.digitalcollections.model.identifiable.entity.Collection> getAssociatedCollections(@PathVariable UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm) throws TechnicalException {
        PageRequest pageRequest = new PageRequest(searchTerm, pageNumber, pageSize);
        return this.service.findCollections(uuid, pageRequest);
    }

    @GetMapping(value={"/api/digitalobjects/{uuid}/projects"}, produces={"application/json"})
    @ResponseBody
    public PageResponse<Project> getAssociatedProjects(@PathVariable UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm) throws TechnicalException {
        PageRequest pageRequest = new PageRequest(searchTerm, pageNumber, pageSize);
        return this.service.findProjects(uuid, pageRequest);
    }

    @GetMapping(value={"/api/digitalobjects/identifier/{namespace}:{id}"})
    @ResponseBody
    public DigitalObject getByIdentifier(@PathVariable String namespace, @PathVariable String id) throws TechnicalException {
        return (DigitalObject)this.service.getByIdentifier(namespace, id);
    }

    @GetMapping(value={"/api/digitalobjects/{refId:[0-9]+}"})
    @ResponseBody
    public DigitalObject getByRefId(@PathVariable long refId) throws TechnicalException {
        return (DigitalObject)this.service.getByRefId(refId);
    }

    @GetMapping(value={"/api/digitalobjects/{uuid:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}}"})
    @ResponseBody
    public DigitalObject getByUuid(@PathVariable UUID uuid) throws TechnicalException {
        return (DigitalObject)this.service.getByUuid(uuid);
    }

    @GetMapping(value={"/api/digitalobjects/{uuid}/digitalobjects"})
    @ResponseBody
    public PageResponse<DigitalObject> getContainedDigitalObjects(@PathVariable UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm) throws TechnicalException {
        PageRequest pageRequest = PageRequest.builder().pageNumber(pageNumber).pageSize(pageSize).searchTerm(searchTerm).sorting(Sorting.builder().order(Order.builder().property("label").subProperty(this.localeService.getDefaultLanguage().getLanguage()).build()).build()).build();
        return this.service.getAllForParent(((DigitalObject.DigitalObjectBuilder)DigitalObject.builder().uuid(uuid)).build(), pageRequest);
    }

    @GetMapping(value={"/digitalobjects"})
    public String list(Model model) throws TechnicalException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        model.addAttribute("existingLanguages", (Object)this.languageSortingHelper.sortLanguages(displayLocale, (Collection)this.service.getLanguages()));
        return "digitalobjects/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "digitalobjects";
    }

    @GetMapping(value={"/digitalobjects/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) throws TechnicalException, ResourceNotFoundException {
        DigitalObject digitalObject = (DigitalObject)this.service.getByUuid(uuid);
        if (digitalObject == null) {
            throw new ResourceNotFoundException();
        }
        Locale displayLocale = LocaleContextHolder.getLocale();
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)digitalObject.getLabel().getLocales());
        List existingCollectionLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)this.service.getLanguagesOfCollections(uuid));
        List existingProjectLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)this.service.getLanguagesOfProjects(uuid));
        List existingContainedDigitalObjectLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)this.service.getLanguagesOfContainedDigitalObjects(uuid));
        model.addAttribute("digitalObject", (Object)digitalObject).addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("existingCollectionLanguages", (Object)existingCollectionLanguages).addAttribute("existingContainedDigitalObjectLanguages", (Object)existingContainedDigitalObjectLanguages).addAttribute("existingProjectLanguages", (Object)existingProjectLanguages);
        return "digitalobjects/view";
    }
}

