/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.util.LanguageSortingHelper;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiWebsitesClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WebsitesController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsitesController.class);
    private final LanguageSortingHelper languageSortingHelper;
    private final CudamiLocalesClient localeService;
    private final CudamiWebsitesClient service;

    public WebsitesController(LanguageSortingHelper languageSortingHelper, CudamiClient client) {
        this.languageSortingHelper = languageSortingHelper;
        this.localeService = client.forLocales();
        this.service = client.forWebsites();
    }

    @GetMapping(value={"/websites/new"})
    public String create(Model model) throws TechnicalException {
        model.addAttribute("activeLanguage", (Object)this.localeService.getDefaultLanguage());
        return "websites/create";
    }

    @GetMapping(value={"/api/websites/new"})
    @ResponseBody
    public Website create() throws TechnicalException {
        return (Website)this.service.create();
    }

    @GetMapping(value={"/websites/{uuid}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws TechnicalException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Website website = (Website)this.service.getByUuid(uuid);
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)website.getLabel().getLocales());
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("url", (Object)website.getUrl());
        model.addAttribute("uuid", (Object)website.getUuid());
        return "websites/edit";
    }

    @GetMapping(value={"/api/websites"})
    @ResponseBody
    public PageResponse<Website> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm, @RequestParam(name="sortBy", required=false) List<Order> sortBy) throws TechnicalException {
        PageRequest pageRequest = new PageRequest(searchTerm, pageNumber, pageSize);
        if (sortBy != null) {
            Sorting sorting = new Sorting(sortBy);
            pageRequest.setSorting(sorting);
        }
        return this.service.find(pageRequest);
    }

    @GetMapping(value={"/api/websites/{uuid}/webpages"})
    @ResponseBody
    public PageResponse<Webpage> findRootpages(@PathVariable UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm) throws TechnicalException {
        PageRequest pageRequest = new PageRequest(searchTerm, pageNumber, pageSize);
        return this.service.findRootWebpages(uuid, pageRequest);
    }

    @GetMapping(value={"/api/websites/{uuid}"})
    @ResponseBody
    public Website getByUuid(@PathVariable UUID uuid) throws TechnicalException {
        return (Website)this.service.getByUuid(uuid);
    }

    @GetMapping(value={"/websites"})
    public String list(Model model) throws TechnicalException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        model.addAttribute("existingLanguages", (Object)this.languageSortingHelper.sortLanguages(displayLocale, (Collection)this.service.getLanguages()));
        return "websites/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "websites";
    }

    @PostMapping(value={"/api/websites"})
    public ResponseEntity save(@RequestBody Website website) {
        try {
            Website websiteDb = (Website)this.service.save((UniqueObject)website);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)websiteDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save website: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/websites/{uuid}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Website website) {
        try {
            Website websiteDb = (Website)this.service.update(uuid, (UniqueObject)website);
            return ResponseEntity.ok((Object)websiteDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save website with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/websites/{uuid}/webpages"})
    public ResponseEntity updateRootPagesOrder(@PathVariable UUID uuid, @RequestBody List<Webpage> rootPages) throws TechnicalException {
        boolean successful = this.service.updateRootWebpagesOrder(uuid, rootPages);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/websites/{uuid}"})
    public String view(@PathVariable UUID uuid, Model model) throws TechnicalException, ResourceNotFoundException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Website website = (Website)this.service.getByUuid(uuid);
        if (website == null) {
            throw new ResourceNotFoundException();
        }
        List existingLanguages = this.languageSortingHelper.sortLanguages(displayLocale, (Collection)website.getLabel().getLocales());
        List existingWebpageLanguages = website.getRootPages().stream().flatMap(child -> child.getLabel().getLocales().stream()).collect(Collectors.toList());
        model.addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("existingWebpageLanguages", (Object)this.languageSortingHelper.sortLanguages(displayLocale, existingWebpageLanguages)).addAttribute("website", (Object)website);
        return "websites/view";
    }
}

