/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.AbstractIdentifiablesController;
import de.digitalcollections.cudami.admin.controller.identifiable.IdentifiableController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.CudamiIdentifiablesClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiHeadwordEntriesClient;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.IdentifiableObjectType;
import de.digitalcollections.model.identifiable.entity.HeadwordEntry;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class IdentifiableController
extends AbstractIdentifiablesController<Identifiable, CudamiIdentifiablesClient<Identifiable>> {
    CudamiHeadwordEntriesClient headwordEntriesService;

    public IdentifiableController(CudamiClient client, LanguageService languageService) {
        super(client.forIdentifiables(), languageService);
        this.headwordEntriesService = client.forHeadwordEntries();
    }

    public String doForward(Identifiable identifiable, Model model) throws TechnicalException {
        String uuid = identifiable.getUuid().toString();
        IdentifiableObjectType identifiableObjectType = identifiable.getIdentifiableObjectType();
        switch (1.$SwitchMap$de$digitalcollections$model$identifiable$IdentifiableObjectType[identifiableObjectType.ordinal()]) {
            case 1: {
                return "forward:/articles/" + uuid;
            }
            case 2: {
                return "forward:/collections/" + uuid;
            }
            case 3: {
                return "forward:/corporatebodies/" + uuid;
            }
            case 4: {
                return "forward:/digitalobjects/" + uuid;
            }
            case 5: {
                return "forward:/geolocations/" + uuid;
            }
            case 6: {
                HeadwordEntry headwordEntry = (HeadwordEntry)this.headwordEntriesService.getByUuid(identifiable.getUuid());
                UUID headwordUuid = headwordEntry.getHeadword().getUuid();
                return "redirect:/headwords/" + headwordUuid;
            }
            case 7: {
                return "forward:/items/" + uuid;
            }
            case 8: {
                return "forward:/manifestations/" + uuid;
            }
            case 9: {
                return "forward:/persons/" + uuid;
            }
            case 10: {
                return "forward:/topics/" + uuid;
            }
            case 11: {
                return "forward:/works/" + uuid;
            }
        }
        throw new TechnicalException("Unhandled object type " + identifiable.getIdentifiableObjectType());
    }

    @GetMapping(value={"/identifiables"})
    @ResponseBody
    public List<Identifiable> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="searchField", required=false, defaultValue="label") String searchField, @RequestParam(name="term", required=false) String searchTerm, @RequestParam(name="sortBy", required=false) List<Order> sortBy) throws TechnicalException {
        String dataLanguage = null;
        PageRequest pageRequest = this.createPageRequest(Identifiable.class, pageNumber, pageSize, sortBy, searchField, searchTerm, dataLanguage);
        PageResponse response = this.service.find(pageRequest);
        return response.getContent();
    }

    @GetMapping(value={"/identifiables/{namespace:[a-zA-Z_\\-]+}:{id:.+}"})
    public String view(@PathVariable String namespace, @PathVariable String id, Model model) throws TechnicalException, ResourceNotFoundException {
        Identifiable identifiable = ((CudamiIdentifiablesClient)this.service).getByIdentifier(namespace, id);
        if (identifiable == null) {
            throw new ResourceNotFoundException("get entity by identifier with " + namespace + ":" + id);
        }
        return this.doForward(identifiable, model);
    }

    @GetMapping(value={"/identifiables/{base64:[^:]+}"})
    public String viewBase64Encoded(@PathVariable String base64, Model model) throws TechnicalException, ResourceNotFoundException {
        String id;
        String paramString = new String(Base64.decodeBase64((String)base64), StandardCharsets.UTF_8);
        Pattern identifierParamPattern = Pattern.compile("^([^:]+?):(.*)$");
        Matcher identifierParamMatcher = identifierParamPattern.matcher(paramString);
        if (!identifierParamMatcher.matches()) {
            throw new ResourceNotFoundException("get entity by identifier with " + paramString);
        }
        String namespace = identifierParamMatcher.group(1);
        Identifiable identifiable = ((CudamiIdentifiablesClient)this.service).getByIdentifier(namespace, id = identifierParamMatcher.group(2));
        if (identifiable == null) {
            throw new ResourceNotFoundException("get entity by identifier with " + namespace + ":" + id);
        }
        return this.doForward(identifiable, model);
    }
}

