/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.entity.AbstractEntitiesController;
import de.digitalcollections.cudami.admin.model.bootstraptable.BTResponse;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiArticlesClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.entity.Article;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ArticlesAPIController
extends AbstractEntitiesController<Article, CudamiArticlesClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArticlesAPIController.class);

    public ArticlesAPIController(CudamiClient client, LanguageService languageService) {
        super((CudamiEntitiesClient)client.forArticles(), languageService);
    }

    @GetMapping(value={"/api/articles/new"})
    @ResponseBody
    public Article create() throws TechnicalException {
        return (Article)this.service.create();
    }

    @GetMapping(value={"/api/articles"})
    @ResponseBody
    @SuppressFBWarnings
    public BTResponse<Article> find(@RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException {
        return this.find(Article.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
    }

    @GetMapping(value={"/api/articles/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    @ResponseBody
    public Article getByUuid(@PathVariable UUID uuid) throws TechnicalException {
        return (Article)this.service.getByUuid(uuid);
    }

    @PostMapping(value={"/api/articles"})
    public ResponseEntity save(@RequestBody Article article) {
        try {
            Article articleDb = (Article)this.service.save((UniqueObject)article);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)articleDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save article: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/articles/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Article article) {
        try {
            Article articleDb = (Article)this.service.update(uuid, (UniqueObject)article);
            return ResponseEntity.ok((Object)articleDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save article with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }
}

