/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.entity.AbstractEntitiesController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiCollectionsClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class CollectionsController
extends AbstractEntitiesController<de.digitalcollections.model.identifiable.entity.Collection, CudamiCollectionsClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionsController.class);

    public CollectionsController(CudamiClient client, LanguageService languageService) {
        super((CudamiEntitiesClient)client.forCollections(), languageService);
    }

    @GetMapping(value={"/collections/new"})
    public String create(Model model, @RequestParam(name="parentType", required=false) String parentType, @RequestParam(name="parentUuid", required=false) UUID parentUuid) throws TechnicalException {
        model.addAttribute("activeLanguage", (Object)this.languageService.getDefaultLanguage());
        model.addAttribute("parentType", (Object)parentType);
        model.addAttribute("parentUuid", (Object)parentUuid);
        return "collections/create";
    }

    @GetMapping(value={"/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws TechnicalException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        de.digitalcollections.model.identifiable.entity.Collection collection = (de.digitalcollections.model.identifiable.entity.Collection)this.service.getByUuid(uuid);
        List existingLanguages = this.languageService.sortLanguages(displayLocale, (Collection)collection.getLabel().getLocales());
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("uuid", (Object)collection.getUuid());
        return "collections/edit";
    }

    @GetMapping(value={"/collections"})
    public String list(Model model) throws TechnicalException {
        List existingLanguages = this.languageService.getExistingLanguagesForLocales(((CudamiCollectionsClient)this.service).getLanguagesOfTopCollections());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        String dataLanguage = this.getDataLanguage(null, this.languageService);
        model.addAttribute("dataLanguage", (Object)dataLanguage);
        return "collections/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "collections";
    }

    @GetMapping(value={"/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public String view(@PathVariable UUID uuid, @RequestParam(name="dataLanguage", required=false) String targetDataLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        de.digitalcollections.model.identifiable.entity.Collection collection = (de.digitalcollections.model.identifiable.entity.Collection)this.service.getByUuid(uuid);
        if (collection == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("collection", (Object)collection);
        List existingLanguages = this.getExistingLanguagesFromIdentifiables(List.of(collection));
        String dataLanguage = this.getDataLanguage(targetDataLanguage, this.languageService);
        model.addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("dataLanguage", (Object)dataLanguage);
        List existingSubcollectionsLanguages = this.getExistingLanguagesFromIdentifiables(collection.getChildren());
        model.addAttribute("existingSubcollectionsLanguages", (Object)existingSubcollectionsLanguages).addAttribute("dataLanguageSubcollections", (Object)this.getDataLanguage(null, this.languageService));
        List parents = ((CudamiCollectionsClient)this.service).getParents(uuid);
        model.addAttribute("parents", (Object)parents);
        BreadcrumbNavigation breadcrumbNavigation = ((CudamiCollectionsClient)this.service).getBreadcrumbNavigation(uuid);
        List breadcrumbs = breadcrumbNavigation.getNavigationItems();
        model.addAttribute("breadcrumbs", (Object)breadcrumbs);
        return "collections/view";
    }

    @GetMapping(value={"/collections/{refId:[0-9]+}"})
    public String viewByRefId(@PathVariable long refId, @RequestParam(name="dataLanguage", required=false) String targetDataLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        de.digitalcollections.model.identifiable.entity.Collection collection = (de.digitalcollections.model.identifiable.entity.Collection)((CudamiEntitiesClient)this.service).getByRefId(refId);
        if (collection == null) {
            throw new ResourceNotFoundException();
        }
        return this.view(collection.getUuid(), targetDataLanguage, model);
    }
}

