/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.entity.AbstractEntitiesController;
import de.digitalcollections.cudami.admin.model.bootstraptable.BTRequest;
import de.digitalcollections.cudami.admin.model.bootstraptable.BTResponse;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.CudamiIdentifiablesClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiDigitalObjectsClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.Project;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.InvalidEndpointRequestException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DigitalObjectsAPIController
extends AbstractEntitiesController<DigitalObject, CudamiDigitalObjectsClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigitalObjectsAPIController.class);

    public DigitalObjectsAPIController(CudamiClient client, LanguageService languageService) {
        super((CudamiEntitiesClient)client.forDigitalObjects(), languageService);
    }

    @GetMapping(value={"/api/digitalobjects/search"})
    @ResponseBody
    public PageResponse<DigitalObject> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="searchField", required=false) String searchField, @RequestParam(name="searchTerm", required=false) String searchTerm, @RequestParam(name="sortBy", required=false) List<Order> sortBy) throws TechnicalException {
        String dataLanguage = null;
        PageRequest pageRequest = this.createPageRequest(DigitalObject.class, pageNumber, pageSize, sortBy, searchField, searchTerm, dataLanguage);
        PageResponse pageResponse = this.search(searchField, searchTerm, pageRequest);
        if (pageResponse == null) {
            throw new InvalidEndpointRequestException("invalid request param", searchField);
        }
        return pageResponse;
    }

    @GetMapping(value={"/api/digitalobjects"})
    @ResponseBody
    @SuppressFBWarnings
    public BTResponse<DigitalObject> find(@RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException {
        return this.find(DigitalObject.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
    }

    @GetMapping(value={"/api/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/collections"}, produces={"application/json"})
    @ResponseBody
    public BTResponse<Collection> findAssociatedCollections(@PathVariable UUID uuid, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException {
        BTRequest btRequest = this.createBTRequest(Collection.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
        PageResponse pageResponse = ((CudamiDigitalObjectsClient)this.service).findCollections(uuid, (PageRequest)btRequest);
        return new BTResponse(pageResponse);
    }

    @GetMapping(value={"/api/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/projects"}, produces={"application/json"})
    @ResponseBody
    public BTResponse<Project> findAssociatedProjects(@PathVariable UUID uuid, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException {
        BTRequest btRequest = this.createBTRequest(Project.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
        PageResponse pageResponse = ((CudamiDigitalObjectsClient)this.service).findProjects(uuid, (PageRequest)btRequest);
        return new BTResponse(pageResponse);
    }

    @GetMapping(value={"/api/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects"})
    @ResponseBody
    public BTResponse<DigitalObject> findContainedDigitalObjects(@PathVariable UUID uuid, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException {
        BTRequest btRequest = this.createBTRequest(DigitalObject.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
        PageResponse pageResponse = ((CudamiDigitalObjectsClient)this.service).getAllForParent(((DigitalObject.DigitalObjectBuilder)DigitalObject.builder().uuid(uuid)).build(), (PageRequest)btRequest);
        return new BTResponse(pageResponse);
    }

    @GetMapping(value={"/api/digitalobjects/identifier/{namespace}:{id}"})
    @ResponseBody
    public DigitalObject getByIdentifier(@PathVariable String namespace, @PathVariable String id) throws TechnicalException {
        return (DigitalObject)((CudamiIdentifiablesClient)this.service).getByIdentifier(namespace, id);
    }

    @GetMapping(value={"/api/digitalobjects/{refId:[0-9]+}"})
    @ResponseBody
    public DigitalObject getByRefId(@PathVariable long refId) throws TechnicalException {
        return (DigitalObject)((CudamiEntitiesClient)this.service).getByRefId(refId);
    }

    @GetMapping(value={"/api/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    @ResponseBody
    public DigitalObject getByUuid(@PathVariable UUID uuid) throws TechnicalException {
        return (DigitalObject)this.service.getByUuid(uuid);
    }
}

