/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.entity.AbstractEntitiesController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiDigitalObjectsClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DigitalObjectsController
extends AbstractEntitiesController<DigitalObject, CudamiDigitalObjectsClient> {
    public DigitalObjectsController(CudamiClient client, LanguageService languageService) {
        super((CudamiEntitiesClient)client.forDigitalObjects(), languageService);
    }

    @GetMapping(value={"/digitalobjects"})
    public String list(Model model) throws TechnicalException {
        model.addAttribute("existingLanguages", (Object)this.getExistingLanguagesFromService());
        String dataLanguage = this.getDataLanguage(null, this.languageService);
        model.addAttribute("dataLanguage", (Object)dataLanguage);
        return "digitalobjects/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "digitalobjects";
    }

    @GetMapping(value={"/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public String view(@PathVariable UUID uuid, @RequestParam(name="dataLanguage", required=false) String targetDataLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        DigitalObject digitalObject = (DigitalObject)this.service.getByUuid(uuid);
        if (digitalObject == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("digitalObject", (Object)digitalObject);
        List existingLanguages = this.getExistingLanguagesFromIdentifiable((Identifiable)digitalObject);
        String dataLanguage = this.getDataLanguage(targetDataLanguage, this.languageService);
        model.addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("dataLanguage", (Object)dataLanguage);
        Locale displayLocale = LocaleContextHolder.getLocale();
        List existingCollectionsLanguages = ((CudamiDigitalObjectsClient)this.service).getLanguagesOfCollections(uuid);
        model.addAttribute("existingCollectionsLanguages", (Object)this.languageService.sortLanguages(displayLocale, (Collection)existingCollectionsLanguages)).addAttribute("dataLanguageCollections", (Object)this.getDataLanguage(null, this.languageService));
        List existingProjectsLanguages = ((CudamiDigitalObjectsClient)this.service).getLanguagesOfProjects(uuid);
        model.addAttribute("existingProjectsLanguages", (Object)this.languageService.sortLanguages(displayLocale, (Collection)existingProjectsLanguages)).addAttribute("dataLanguageProjects", (Object)this.getDataLanguage(null, this.languageService));
        List existingContainedDigitalObjectsLanguages = ((CudamiDigitalObjectsClient)this.service).getLanguagesOfContainedDigitalObjects(uuid);
        model.addAttribute("existingDigitalObjectsLanguages", (Object)this.languageService.sortLanguages(displayLocale, (Collection)existingContainedDigitalObjectsLanguages)).addAttribute("dataLanguageDigitalObjects", (Object)this.getDataLanguage(null, this.languageService));
        return "digitalobjects/view";
    }
}

