/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.entity.AbstractEntitiesController;
import de.digitalcollections.cudami.admin.model.bootstraptable.BTResponse;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiHeadwordEntriesClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.entity.HeadwordEntry;
import de.digitalcollections.model.relation.Predicate;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HeadwordEntriesAPIController
extends AbstractEntitiesController<HeadwordEntry, CudamiHeadwordEntriesClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeadwordEntriesAPIController.class);

    public HeadwordEntriesAPIController(CudamiClient client, LanguageService languageService) {
        super((CudamiEntitiesClient)client.forHeadwordEntries(), languageService);
    }

    @GetMapping(value={"/api/headwordentries/new"})
    @ResponseBody
    public HeadwordEntry create() throws TechnicalException {
        return (HeadwordEntry)this.service.create();
    }

    @GetMapping(value={"/api/headwordentries"})
    @ResponseBody
    @SuppressFBWarnings
    public BTResponse<HeadwordEntry> find(@RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException {
        return this.find(Predicate.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
    }

    @GetMapping(value={"/api/headwordentries/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    @ResponseBody
    public HeadwordEntry getByUuid(@PathVariable UUID uuid) throws TechnicalException {
        return (HeadwordEntry)this.service.getByUuid(uuid);
    }

    @PostMapping(value={"/api/headwordentries"})
    public ResponseEntity save(@RequestBody HeadwordEntry headwordEntry) {
        try {
            HeadwordEntry headwordEntryDb = (HeadwordEntry)this.service.save((UniqueObject)headwordEntry);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)headwordEntryDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save headwordEntry: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/headwordentries/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody HeadwordEntry headwordEntry) {
        try {
            HeadwordEntry headwordEntryDb = (HeadwordEntry)this.service.update(uuid, (UniqueObject)headwordEntry);
            return ResponseEntity.ok((Object)headwordEntryDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save headwordEntry with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }
}

