/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.entity.AbstractEntitiesController;
import de.digitalcollections.cudami.admin.model.bootstraptable.BTRequest;
import de.digitalcollections.cudami.admin.model.bootstraptable.BTResponse;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiTopicsClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.Topic;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TopicsAPIController
extends AbstractEntitiesController<Topic, CudamiTopicsClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopicsAPIController.class);

    public TopicsAPIController(CudamiClient client, LanguageService languageService) {
        super((CudamiEntitiesClient)client.forTopics(), languageService);
    }

    @GetMapping(value={"/api/topics/new"})
    @ResponseBody
    public Topic create() throws TechnicalException {
        return (Topic)this.service.create();
    }

    @GetMapping(value={"/api/topics/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/entities"})
    @ResponseBody
    public BTResponse<Entity> findRelatedEntities(@PathVariable UUID uuid, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException {
        BTRequest btRequest = this.createBTRequest(Entity.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
        PageResponse pageResponse = ((CudamiTopicsClient)this.service).findEntities(uuid, (PageRequest)btRequest);
        return new BTResponse(pageResponse);
    }

    @GetMapping(value={"/api/topics/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/fileresources"})
    @ResponseBody
    public BTResponse<FileResource> findRelatedFileResources(@PathVariable UUID uuid, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException {
        BTRequest btRequest = this.createBTRequest(FileResource.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
        PageResponse pageResponse = ((CudamiTopicsClient)this.service).findFileResources(uuid, (PageRequest)btRequest);
        return new BTResponse(pageResponse);
    }

    @GetMapping(value={"/api/topics/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/topics"})
    @ResponseBody
    public BTResponse<Topic> findSubtopic(@PathVariable UUID uuid, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException {
        BTRequest btRequest = this.createBTRequest(Topic.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
        PageResponse pageResponse = ((CudamiTopicsClient)this.service).findSubtopics(uuid, (PageRequest)btRequest);
        return new BTResponse(pageResponse);
    }

    @GetMapping(value={"/api/topics"})
    @ResponseBody
    @SuppressFBWarnings
    public BTResponse<Topic> findTop(@RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException {
        BTRequest btRequest = this.createBTRequest(Topic.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
        PageResponse pageResponse = ((CudamiTopicsClient)this.service).findTopTopics((PageRequest)btRequest);
        return new BTResponse(pageResponse);
    }

    @GetMapping(value={"/api/topics/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    @ResponseBody
    public Topic getByUuid(@PathVariable UUID uuid) throws TechnicalException {
        return (Topic)this.service.getByUuid(uuid);
    }

    @PostMapping(value={"/api/topics"})
    public ResponseEntity save(@RequestBody Topic topic, @RequestParam(name="parentUuid", required=false) UUID parentUuid) {
        try {
            Topic topicDb = null;
            topicDb = parentUuid == null ? (Topic)this.service.save((UniqueObject)topic) : ((CudamiTopicsClient)this.service).saveWithParentTopic(topic, parentUuid);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)topicDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save topic: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/topics/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Topic topic) {
        try {
            Topic topicDb = (Topic)this.service.update(uuid, (UniqueObject)topic);
            return ResponseEntity.ok((Object)topicDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save topic with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }
}

