/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.entity.AbstractEntitiesController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiTopicsClient;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.entity.Topic;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class TopicsController
extends AbstractEntitiesController<Topic, CudamiTopicsClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopicsController.class);

    public TopicsController(CudamiClient client, LanguageService languageService) {
        super((CudamiEntitiesClient)client.forTopics(), languageService);
    }

    @GetMapping(value={"/topics/new"})
    public String create(Model model, @RequestParam(name="parentType", required=false) String parentType, @RequestParam(name="parentUuid", required=false) UUID parentUuid) throws TechnicalException {
        model.addAttribute("activeLanguage", (Object)this.languageService.getDefaultLanguage());
        model.addAttribute("parentType", (Object)parentType);
        model.addAttribute("parentUuid", (Object)parentUuid);
        return "topics/create";
    }

    @GetMapping(value={"/topics/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws TechnicalException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        Topic topic = (Topic)this.service.getByUuid(uuid);
        List existingLanguages = this.languageService.sortLanguages(displayLocale, (Collection)topic.getLabel().getLocales());
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("uuid", (Object)topic.getUuid());
        return "topics/edit";
    }

    @GetMapping(value={"/topics"})
    public String list(Model model) throws TechnicalException {
        model.addAttribute("existingLanguages", (Object)this.languageService.getExistingLanguagesForLocales(((CudamiTopicsClient)this.service).getLanguagesOfTopTopics()));
        String dataLanguage = this.getDataLanguage(null, this.languageService);
        model.addAttribute("dataLanguage", (Object)dataLanguage);
        return "topics/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "topics";
    }

    @GetMapping(value={"/topics/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public String view(@PathVariable UUID uuid, @RequestParam(name="dataLanguage", required=false) String targetDataLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        Topic topic = (Topic)this.service.getByUuid(uuid);
        if (topic == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("topic", (Object)topic);
        List existingLanguages = this.getExistingLanguagesFromIdentifiable((Identifiable)topic);
        String dataLanguage = this.getDataLanguage(targetDataLanguage, this.languageService);
        model.addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("dataLanguage", (Object)dataLanguage);
        List existingSubtopicsLanguages = this.getExistingLanguagesFromIdentifiables(topic.getChildren());
        model.addAttribute("existingSubtopicsLanguages", (Object)existingSubtopicsLanguages).addAttribute("dataLanguageSubtopics", (Object)this.getDataLanguage(null, this.languageService));
        Locale displayLocale = LocaleContextHolder.getLocale();
        List existingEntitiesLanguages = ((CudamiTopicsClient)this.service).getLanguagesOfEntities(uuid);
        model.addAttribute("existingEntitiesLanguages", (Object)this.languageService.sortLanguages(displayLocale, (Collection)existingEntitiesLanguages)).addAttribute("dataLanguageEntities", (Object)this.getDataLanguage(null, this.languageService));
        List existingFileResourcesLanguages = ((CudamiTopicsClient)this.service).getLanguagesOfFileResources(uuid);
        model.addAttribute("existingFileResourcesLanguages", (Object)this.languageService.sortLanguages(displayLocale, (Collection)existingFileResourcesLanguages)).addAttribute("dataLanguageFileResources", (Object)this.getDataLanguage(null, this.languageService));
        BreadcrumbNavigation breadcrumbNavigation = ((CudamiTopicsClient)this.service).getBreadcrumbNavigation(uuid);
        List breadcrumbs = breadcrumbNavigation.getNavigationItems();
        model.addAttribute("breadcrumbs", (Object)breadcrumbs);
        return "topics/view";
    }

    @GetMapping(value={"/topics/{refId:[0-9]+}"})
    public String viewByRefId(@PathVariable long refId, @RequestParam(name="dataLanguage", required=false) String targetDataLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        Topic topic = (Topic)((CudamiEntitiesClient)this.service).getByRefId(refId);
        if (topic == null) {
            throw new ResourceNotFoundException();
        }
        return this.view(topic.getUuid(), targetDataLanguage, model);
    }
}

