/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.cudami.admin.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.entity.AbstractEntitiesController;
import de.digitalcollections.cudami.admin.model.bootstraptable.BTRequest;
import de.digitalcollections.cudami.admin.model.bootstraptable.BTResponse;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiWebsitesClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class WebsitesAPIController
extends AbstractEntitiesController<Website, CudamiWebsitesClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsitesAPIController.class);

    public WebsitesAPIController(CudamiClient client, LanguageService languageService) {
        super((CudamiEntitiesClient)client.forWebsites(), languageService);
    }

    @GetMapping(value={"/api/websites/new"})
    @ResponseBody
    public Website create() throws TechnicalException {
        return (Website)this.service.create();
    }

    @GetMapping(value={"/api/websites"})
    @ResponseBody
    @SuppressFBWarnings
    public BTResponse<Website> find(@RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException, ServiceException {
        return this.find(Website.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
    }

    @GetMapping(value={"/api/websites/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/webpages"})
    @ResponseBody
    public BTResponse<Webpage> findRootpages(@PathVariable UUID uuid, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException {
        BTRequest btRequest = this.createBTRequest(Webpage.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
        PageResponse pageResponse = ((CudamiWebsitesClient)this.service).findRootWebpages(uuid, (PageRequest)btRequest);
        return new BTResponse(pageResponse);
    }

    @GetMapping(value={"/api/websites/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    @ResponseBody
    public Website getByUuid(@PathVariable UUID uuid) throws TechnicalException {
        return (Website)this.service.getByUuid(uuid);
    }

    @PostMapping(value={"/api/websites"})
    public ResponseEntity save(@RequestBody Website website) {
        try {
            Website websiteDb = (Website)this.service.save((UniqueObject)website);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)websiteDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save website: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/websites/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Website website) {
        try {
            Website websiteDb = (Website)this.service.update(uuid, (UniqueObject)website);
            return ResponseEntity.ok((Object)websiteDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save website with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/websites/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/webpages"})
    public ResponseEntity updateRootPagesOrder(@PathVariable UUID uuid, @RequestBody List<Webpage> rootPages) throws TechnicalException {
        boolean successful = ((CudamiWebsitesClient)this.service).updateRootWebpagesOrder(uuid, rootPages);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }
}

