/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.business.impl.validator.LabelNotBlankValidator;
import de.digitalcollections.cudami.admin.controller.identifiable.entity.AbstractEntitiesController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiWebsitesClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.text.LocalizedText;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class WebsitesController
extends AbstractEntitiesController<Website, CudamiWebsitesClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsitesController.class);
    private final LabelNotBlankValidator labelNotBlankValidator;
    private final MessageSource messageSource;
    boolean useReact = true;

    public WebsitesController(CudamiClient client, LanguageService languageService, MessageSource messageSource, LabelNotBlankValidator labelNotBlankValidator) {
        super((CudamiEntitiesClient)client.forWebsites(), languageService);
        this.labelNotBlankValidator = labelNotBlankValidator;
        this.messageSource = messageSource;
    }

    @GetMapping(value={"/websites/new"})
    public String create(Model model) throws TechnicalException {
        if (this.useReact) {
            model.addAttribute("activeLanguage", (Object)this.languageService.getDefaultLanguage());
            return "websites/create";
        }
        Website website = (Website)this.service.create();
        Locale defaultLanguage = this.languageService.getDefaultLanguage();
        website.setLabel(new LocalizedText(defaultLanguage, ""));
        model.addAttribute("website", (Object)website);
        List<Locale> existingLanguages = List.of(defaultLanguage);
        model.addAttribute("existingLanguages", existingLanguages);
        model.addAttribute("allLanguages", (Object)this.languageService.getAllLanguages());
        model.addAttribute("activeLanguage", (Object)defaultLanguage);
        model.addAttribute("mode", (Object)"create");
        return "websites/create-or-edit";
    }

    @GetMapping(value={"/websites/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws TechnicalException {
        if (this.useReact) {
            Locale displayLocale = LocaleContextHolder.getLocale();
            Website website = (Website)this.service.getByUuid(uuid);
            List existingLanguages = this.languageService.sortLanguages(displayLocale, (Collection)website.getLabel().getLocales());
            if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
                model.addAttribute("activeLanguage", (Object)activeLanguage);
            } else {
                model.addAttribute("activeLanguage", existingLanguages.get(0));
            }
            model.addAttribute("existingLanguages", (Object)existingLanguages);
            model.addAttribute("url", (Object)website.getUrl());
            model.addAttribute("uuid", (Object)website.getUuid());
            return "websites/edit";
        }
        Website website = (Website)this.service.getByUuid(uuid);
        model.addAttribute("website", (Object)website);
        List existingLanguages = this.languageService.getExistingLanguages(this.languageService.getDefaultLanguage(), website.getLabel());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        model.addAttribute("allLanguages", (Object)this.languageService.getAllLanguages());
        model.addAttribute("mode", (Object)"edit");
        return "websites/create-or-edit";
    }

    @GetMapping(value={"/websites"})
    public String list(Model model) throws TechnicalException {
        model.addAttribute("existingLanguages", (Object)this.getExistingLanguagesFromService());
        String dataLanguage = this.getDataLanguage(null, this.languageService);
        model.addAttribute("dataLanguage", (Object)dataLanguage);
        return "websites/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "websites";
    }

    @PostMapping(value={"/websites/new"})
    public String save(@ModelAttribute @Valid Website website, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) {
        model.addAttribute("mode", (Object)"create");
        this.verifyBinding(results);
        this.labelNotBlankValidator.validate((Object)website.getLabel(), (Errors)results);
        if (results.hasErrors()) {
            return "websites/create-or-edit";
        }
        try {
            this.service.save((UniqueObject)website);
            LOGGER.info("Successfully saved website");
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save website: ", (Throwable)e);
            String message = this.messageSource.getMessage("error.technical_error", null, LocaleContextHolder.getLocale());
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/websites";
        }
        if (results.hasErrors()) {
            return "websites/create-or-edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.created_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/websites";
    }

    @PostMapping(value={"/websites/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/edit"})
    public String update(@PathVariable UUID uuid, @ModelAttribute(value="formData") Website websiteFormData, @ModelAttribute Website website, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) throws TechnicalException {
        model.addAttribute("mode", (Object)"edit");
        this.verifyBinding(results);
        website.setLabel(websiteFormData.getLabel());
        website.setDescription(websiteFormData.getDescription());
        website.setPreviewImageRenderingHints(websiteFormData.getPreviewImageRenderingHints());
        this.labelNotBlankValidator.validate((Object)website.getLabel(), (Errors)results);
        if (results.hasErrors()) {
            Locale defaultLanguage = this.languageService.getDefaultLanguage();
            model.addAttribute("existingLanguages", (Object)this.languageService.getExistingLanguages(defaultLanguage, website.getLabel()));
            model.addAttribute("allLanguages", (Object)this.languageService.getAllLanguages());
            model.addAttribute("activeLanguage", (Object)defaultLanguage);
            return "websites/create-or-edit";
        }
        try {
            this.service.update(uuid, (UniqueObject)website);
        }
        catch (TechnicalException e) {
            String message = "Cannot update website with uuid=" + uuid + ": " + e;
            LOGGER.error(message, (Throwable)e);
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/websites/" + uuid + "/edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changes_saved_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/websites/" + uuid;
    }

    @GetMapping(value={"/websites/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public String view(@PathVariable UUID uuid, @RequestParam(name="dataLanguage", required=false) String targetDataLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        Website website = (Website)this.service.getByUuid(uuid);
        if (website == null) {
            throw new ResourceNotFoundException();
        }
        List existingLanguages = this.getExistingLanguagesFromIdentifiable((Identifiable)website);
        String dataLanguage = this.getDataLanguage(targetDataLanguage, this.languageService);
        model.addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("dataLanguage", (Object)dataLanguage);
        List existingWebpageLanguages = this.getExistingLanguagesFromIdentifiables(website.getRootPages());
        model.addAttribute("existingWebpageLanguages", (Object)existingWebpageLanguages).addAttribute("dataLanguageWebpages", (Object)this.getDataLanguage(null, this.languageService));
        model.addAttribute("website", (Object)website);
        return "websites/view";
    }
}

