/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity.agent;

import de.digitalcollections.cudami.admin.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.AbstractIdentifiablesController;
import de.digitalcollections.cudami.admin.model.bootstraptable.BTResponse;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.CudamiIdentifiablesClient;
import de.digitalcollections.cudami.client.identifiable.agent.CudamiFamilyNamesClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.agent.FamilyName;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FamilynamesAPIController
extends AbstractIdentifiablesController<FamilyName, CudamiFamilyNamesClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FamilynamesAPIController.class);

    public FamilynamesAPIController(CudamiClient client, LanguageService languageService) {
        super((CudamiIdentifiablesClient)client.forFamilyNames(), languageService);
    }

    @GetMapping(value={"/api/familynames/new"})
    @ResponseBody
    public FamilyName create() throws TechnicalException {
        return (FamilyName)this.service.create();
    }

    @GetMapping(value={"/api/familynames"})
    @ResponseBody
    @SuppressFBWarnings
    public BTResponse<FamilyName> find(@RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException, ServiceException {
        return this.find(FamilyName.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
    }

    @GetMapping(value={"/api/familynames/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    @ResponseBody
    public FamilyName getByUuid(@PathVariable UUID uuid) throws TechnicalException {
        return (FamilyName)this.service.getByUuid(uuid);
    }

    @PostMapping(value={"/api/familynames"})
    public ResponseEntity save(@RequestBody FamilyName familyName) {
        try {
            FamilyName familyNameDb = (FamilyName)this.service.save((UniqueObject)familyName);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)familyNameDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save family name: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/familynames/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody FamilyName familyName) {
        try {
            FamilyName familyNameDb = (FamilyName)this.service.update(uuid, (UniqueObject)familyName);
            return ResponseEntity.ok((Object)familyNameDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save family name with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }
}

