/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity.agent;

import de.digitalcollections.cudami.admin.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.AbstractIdentifiablesController;
import de.digitalcollections.cudami.admin.model.bootstraptable.BTResponse;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.CudamiIdentifiablesClient;
import de.digitalcollections.cudami.client.identifiable.agent.CudamiGivenNamesClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.agent.GivenName;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GivennamesAPIController
extends AbstractIdentifiablesController<GivenName, CudamiGivenNamesClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GivennamesAPIController.class);

    public GivennamesAPIController(CudamiClient client, LanguageService languageService) {
        super((CudamiIdentifiablesClient)client.forGivenNames(), languageService);
    }

    @GetMapping(value={"/api/givennames/new"})
    @ResponseBody
    public GivenName create() throws TechnicalException {
        return (GivenName)this.service.create();
    }

    @GetMapping(value={"/api/givennames"})
    @ResponseBody
    @SuppressFBWarnings
    public BTResponse<GivenName> find(@RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException, ServiceException {
        return this.find(GivenName.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
    }

    @GetMapping(value={"/api/givennames/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    @ResponseBody
    public GivenName getByUuid(@PathVariable UUID uuid) throws TechnicalException {
        return (GivenName)this.service.getByUuid(uuid);
    }

    @PostMapping(value={"/api/givennames"})
    public ResponseEntity save(@RequestBody GivenName givenName) {
        try {
            GivenName givenNameDb = (GivenName)this.service.save((UniqueObject)givenName);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)givenNameDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save given name: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/givennames/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody GivenName givenName) {
        try {
            GivenName givenNameDb = (GivenName)this.service.update(uuid, (UniqueObject)givenName);
            return ResponseEntity.ok((Object)givenNameDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save given name with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }
}

