/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity.geo.location;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.entity.AbstractEntitiesController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.cudami.client.identifiable.entity.geo.location.CudamiGeoLocationsClient;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.entity.geo.location.GeoLocation;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class GeoLocationsController
extends AbstractEntitiesController<GeoLocation, CudamiGeoLocationsClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoLocationsController.class);

    public GeoLocationsController(CudamiClient client, LanguageService languageService) {
        super((CudamiEntitiesClient)client.forGeoLocations(), languageService);
    }

    @GetMapping(value={"/geolocations"})
    public String list(Model model) throws TechnicalException {
        model.addAttribute("existingLanguages", (Object)this.getExistingLanguagesFromService());
        String dataLanguage = this.getDataLanguage(null, this.languageService);
        model.addAttribute("dataLanguage", (Object)dataLanguage);
        return "geolocations/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "geolocations";
    }

    @GetMapping(value={"/geolocations/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public String view(@PathVariable UUID uuid, @RequestParam(name="dataLanguage", required=false) String targetDataLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        GeoLocation geoLocation = (GeoLocation)this.service.getByUuid(uuid);
        if (geoLocation == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("geoLocation", (Object)geoLocation);
        List existingLanguages = this.getExistingLanguagesFromIdentifiable((Identifiable)geoLocation);
        String dataLanguage = this.getDataLanguage(targetDataLanguage, this.languageService);
        model.addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("dataLanguage", (Object)dataLanguage);
        return "geolocations/view";
    }
}

